/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.type.AbstractSecurityType;
import com.atlassian.jira.user.ApplicationUser;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIssueFieldSecurityType
extends AbstractSecurityType {
    private static final Logger log = LoggerFactory.getLogger(AbstractIssueFieldSecurityType.class);

    protected abstract String getFieldName(String var1);

    @Override
    public Query getQuery(ApplicationUser searcher, Project project, String parameter) {
        BooleanQuery projectAndUserQuery;
        if (project == null) {
            return null;
        }
        PermissionSchemeManager permissionSchemeManager = ComponentAccessor.getPermissionSchemeManager();
        Long schemeId = permissionSchemeManager.getSchemeIdFor(project);
        if (schemeId == null) {
            throw new IllegalStateException("No permission scheme associated with project " + project.getKey());
        }
        if (permissionSchemeManager.getPermissionSchemeEntries(schemeId.longValue(), ProjectPermissions.BROWSE_PROJECTS, this.getType()).size() > 0 && (projectAndUserQuery = this.getQueryForProject(project, searcher, this.getFieldName(parameter))) != null) {
            BooleanQuery query = new BooleanQuery();
            query.add((Query)projectAndUserQuery, BooleanClause.Occur.SHOULD);
            return query;
        }
        return null;
    }

    @Override
    public Query getQuery(ApplicationUser searcher, Project project, IssueSecurityLevel securityLevel, String parameter) {
        BooleanQuery queryForSecurityLevel = this.getQueryForSecurityLevel(securityLevel, searcher, this.getFieldName(parameter));
        if (queryForSecurityLevel == null) {
            return null;
        }
        BooleanQuery query = new BooleanQuery();
        query.add((Query)queryForSecurityLevel, BooleanClause.Occur.MUST);
        return query;
    }

    @Nullable
    protected BooleanQuery getQueryForProject(@Nonnull Project project, @Nullable ApplicationUser searcher, @Nonnull String fieldName) {
        BooleanQuery projectAndUserQuery = null;
        if (searcher != null) {
            projectAndUserQuery = new BooleanQuery();
            TermQuery projectQuery = new TermQuery(new Term("projid", project.getId().toString()));
            TermQuery userQuery = new TermQuery(new Term(fieldName, searcher.getKey()));
            projectAndUserQuery.add((Query)projectQuery, BooleanClause.Occur.MUST);
            projectAndUserQuery.add((Query)userQuery, BooleanClause.Occur.MUST);
        }
        return projectAndUserQuery;
    }

    @Nullable
    protected BooleanQuery getQueryForSecurityLevel(@Nonnull IssueSecurityLevel issueSecurity, @Nullable ApplicationUser searcher, @Nonnull String fieldName) {
        BooleanQuery issueLevelAndUserQuery = null;
        if (searcher != null) {
            issueLevelAndUserQuery = new BooleanQuery();
            Term securityLevelIsSet = new Term("issue_security_level", issueSecurity.getId().toString());
            Term customFieldSpecifiesUser = new Term(fieldName, searcher.getKey());
            issueLevelAndUserQuery.add((Query)new TermQuery(securityLevelIsSet), BooleanClause.Occur.MUST);
            issueLevelAndUserQuery.add((Query)new TermQuery(customFieldSpecifiesUser), BooleanClause.Occur.MUST);
        }
        return issueLevelAndUserQuery;
    }

    @Override
    public boolean hasPermission(Issue issue, String argument) {
        return false;
    }

    @Override
    public boolean hasPermission(Project project, String argument) {
        return false;
    }

    @Override
    public boolean hasPermission(Issue issue, String parameter, ApplicationUser user, boolean issueCreation) {
        if (user == null || issue == null) {
            return false;
        }
        return this.hasIssuePermission(user, issueCreation, issue, parameter);
    }

    @Override
    public boolean hasPermission(Project project, String parameter, ApplicationUser user, boolean issueCreation) {
        if (user == null || project == null) {
            return false;
        }
        return this.hasProjectPermission(user, issueCreation, project);
    }

    protected abstract boolean hasIssuePermission(ApplicationUser var1, boolean var2, Issue var3, String var4);

    protected abstract boolean hasProjectPermission(ApplicationUser var1, boolean var2, Project var3);
}

