/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.util;

import com.atlassian.jira.permission.PermissionSchemeEntry;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.util.AbstractGroupMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroupToPermissionSchemeMapper
extends AbstractGroupMapper {
    private final PermissionSchemeManager permissionSchemeManager;
    private final PermissionManager permissionManager;

    public GroupToPermissionSchemeMapper(PermissionSchemeManager permissionSchemeManager, PermissionManager permissionManager) {
        this.permissionSchemeManager = permissionSchemeManager;
        this.permissionManager = permissionManager;
        this.setGroupMapping(this.init());
    }

    private Map<String, Set<Scheme>> init() {
        HashMap<String, Set<Scheme>> mapping = new HashMap<String, Set<Scheme>>();
        List schemes = this.permissionSchemeManager.getSchemeObjects();
        for (Scheme permissionScheme : schemes) {
            for (ProjectPermission permission : this.permissionManager.getAllProjectPermissions()) {
                Collection entities = this.permissionSchemeManager.getPermissionSchemeEntries(permissionScheme, permission.getProjectPermissionKey());
                for (PermissionSchemeEntry permissionRecord : entities) {
                    if (!"group".equals(permissionRecord.getType())) continue;
                    this.addEntry(mapping, permissionRecord.getParameter(), permissionScheme);
                }
            }
        }
        return mapping;
    }
}

