/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.cluster;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.NodeStateManager;
import com.atlassian.jira.cluster.NotClusteredException;
import com.atlassian.jira.service.AbstractService;
import com.opensymphony.module.propertyset.PropertySet;

public class NodeStateCheckerService
extends AbstractService {
    private final NodeStateManager nodeStateManager;

    public NodeStateCheckerService(NodeStateManager nodeStateManager) {
        this.nodeStateManager = nodeStateManager;
    }

    public void init(PropertySet properties) throws ObjectConfigurationException {
        super.init(properties);
    }

    public void run() {
        Node refreshedNode;
        Node node = this.nodeStateManager.getNode();
        if (node.isClustered() && node.getState() == Node.NodeState.ACTIVE && (refreshedNode = this.nodeStateManager.getNodeWithRefresh()).getState() == Node.NodeState.PASSIVE) {
            this.passivate();
        }
    }

    private void passivate() {
        try {
            this.nodeStateManager.deactivate();
        }
        catch (NotClusteredException e) {
            throw new IllegalStateException("We got a NotClusteredException trying to passivate in response to a clustered node state change, which is something we only check when we are clustered?!");
        }
    }

    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.getObjectConfiguration("NODESTATECHECKERSERVICE", "services/com/atlassian/jira/service/services/cluster/nodestatecheckerservice.xml", null);
    }
}

