/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.index;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.index.ha.OfBizReplicatedIndexOperationStore;
import com.atlassian.jira.index.ha.ReplicatedIndexOperation;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.service.AbstractService;
import com.atlassian.jira.util.JiraDurationUtils;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatedIndexCleaningService
extends AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplicatedIndexOperation.class);
    public static final String RETENTION_PERIOD = "RETENTION_PERIOD";
    private final ClusterManager clusterManager;
    private final OfBizReplicatedIndexOperationStore ofBizReplicatedIndexOperationStore;
    private final JiraDurationUtils jiraDurationUtils;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private long retentionPeriod;

    public ReplicatedIndexCleaningService(ClusterManager clusterManager, OfBizReplicatedIndexOperationStore ofBizReplicatedIndexOperationStore, JiraDurationUtils jiraDurationUtils, JiraAuthenticationContext jiraAuthenticationContext) {
        this.clusterManager = clusterManager;
        this.ofBizReplicatedIndexOperationStore = ofBizReplicatedIndexOperationStore;
        this.jiraDurationUtils = jiraDurationUtils;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public void init(PropertySet props) throws ObjectConfigurationException {
        super.init(props);
        if (this.hasProperty(RETENTION_PERIOD)) {
            String retention = this.getProperty(RETENTION_PERIOD);
            try {
                this.retentionPeriod = this.jiraDurationUtils.parseDuration(retention, this.jiraAuthenticationContext.getLocale());
            }
            catch (InvalidDurationException e) {
                LOGGER.error("Invalid Duration specified in service configuration", (Throwable)e);
            }
        }
    }

    public void run() {
        Date deleteBeforeTime = new Date(new Date().getTime() - this.retentionPeriod * 1000L);
        for (Node node : this.clusterManager.getAllNodes()) {
            this.ofBizReplicatedIndexOperationStore.purgeOldOperations(node.getNodeId(), deleteBeforeTime);
        }
    }

    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.getObjectConfiguration("INDEXCLEANERSERVICE", "services/com/atlassian/jira/service/services/index/indexcleanerservice.xml", null);
    }

    public long getRetentionPeriod() {
        return this.retentionPeriod;
    }
}

