/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.setup;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationConfigurationHelper;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.extension.JiraStartedEvent;
import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.RenderableField;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.setup.SetupJohnsonUtil;
import com.atlassian.jira.setup.SetupStrategy;
import com.atlassian.jira.startup.DatabaseInitialImporter;
import com.atlassian.jira.upgrade.UpgradeManager;
import com.atlassian.jira.upgrade.UpgradeManagerParams;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.setup.IndexLanguageToLocaleMapper;
import com.atlassian.johnson.event.Event;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class InstantSetupStrategy
implements SetupStrategy<SetupParameters, Step> {
    private static final Logger log = Logger.getLogger(InstantSetupStrategy.class);
    private static final String DEFAULT_GROUP_ADMINS = "jira-administrators";

    public static void setupJiraBaseUrl(String baseUrl) {
        ApplicationProperties applicationProperties = (ApplicationProperties)ComponentAccessor.getComponent(ApplicationProperties.class);
        if (applicationProperties.getString("jira.baseurl") == null) {
            applicationProperties.setString("jira.baseurl", baseUrl);
        }
    }

    private static UserService.CreateUserValidationResult createAdministrator(Map<String, String> credentials) {
        UserService.CreateUserRequest createUserRequest;
        String email = credentials.get("email");
        String username = credentials.get("email");
        String fullname = credentials.get("email");
        String password = credentials.get("password");
        UserService userService = (UserService)ComponentAccessor.getComponent(UserService.class);
        UserService.CreateUserValidationResult result = userService.validateCreateUser(createUserRequest = UserService.CreateUserRequest.withUserDetails(null, (String)username, (String)password, (String)email, (String)fullname).confirmPassword(password).passwordRequired().performPermissionCheck(false).sendNotification(false));
        if (result.isValid()) {
            ApplicationUser administrator;
            try {
                administrator = userService.createUser(result);
            }
            catch (CreateException | PermissionException e) {
                throw new RuntimeException(e);
            }
            GroupManager groupManager = ComponentAccessor.getGroupManager();
            Group groupAdmins = InstantSetupStrategy.getOrCreateGroup(groupManager, DEFAULT_GROUP_ADMINS);
            if (administrator != null && groupAdmins != null) {
                try {
                    if (!groupManager.isUserInGroup(administrator, groupAdmins)) {
                        groupManager.addUserToGroup(administrator, groupAdmins);
                    }
                }
                catch (CrowdException e) {
                    throw new RuntimeException(e);
                }
                GlobalPermissionManager globalPermissionManager = ComponentAccessor.getGlobalPermissionManager();
                if (!globalPermissionManager.getGroupNames(0).contains(DEFAULT_GROUP_ADMINS)) {
                    globalPermissionManager.addPermission(0, DEFAULT_GROUP_ADMINS);
                }
                ApplicationConfigurationHelper appConfigHelper = (ApplicationConfigurationHelper)ComponentAccessor.getComponent(ApplicationConfigurationHelper.class);
                appConfigHelper.configureApplicationsForSetup(Collections.singleton(groupAdmins), true);
                appConfigHelper.setupAdminForDefaultApplications(administrator);
            }
        }
        return result;
    }

    private static Group getOrCreateGroup(GroupManager groupManager, String groupName) {
        Group group = groupManager.getGroup(groupName);
        if (group != null) {
            return group;
        }
        try {
            return groupManager.createGroup(groupName);
        }
        catch (OperationNotPermittedException | InvalidGroupException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setCorrectLocale(String locale) {
        InstantSetupStrategy.setJiraLocale(locale);
        InstantSetupStrategy.setIndexingLanguageForDefaultServerLocale(locale);
    }

    private static void setJiraLocale(String locale) {
        ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
        if (InstantSetupStrategy.isLocaleValid(locale)) {
            applicationProperties.setString("jira.i18n.default.locale", locale);
        }
    }

    private static void setIndexingLanguageForDefaultServerLocale(String locale) {
        ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
        IndexLanguageToLocaleMapper languageToLocaleMapper = (IndexLanguageToLocaleMapper)ComponentAccessor.getComponent(IndexLanguageToLocaleMapper.class);
        applicationProperties.setString("jira.i18n.language.index", languageToLocaleMapper.getLanguageForLocale(locale));
    }

    private static boolean isLocaleValid(String locale) {
        LocaleManager localeManager = (LocaleManager)ComponentAccessor.getComponentOfType(LocaleManager.class);
        Set installedLocales = localeManager.getInstalledLocales();
        return installedLocales.contains(localeManager.getLocale(locale));
    }

    private static String getText(String key) {
        return InstantSetupStrategy.getI18nHelper().getText(key);
    }

    private static String getText(String key, String object) {
        return InstantSetupStrategy.getI18nHelper().getText(key, object);
    }

    private static I18nHelper getI18nHelper() {
        return ((JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class)).getI18nHelper();
    }

    private void doStepTask(SetupStrategy.StepSwitcher<Step> switcher, Step step, SetupStrategy.StepTask stepTask) throws Exception {
        switcher.withStep(step, stepTask);
        SetupJohnsonUtil johnsonUtil = (SetupJohnsonUtil)ComponentAccessor.getComponent(SetupJohnsonUtil.class);
        Collection johnsonEvents = johnsonUtil.getEvents();
        if (johnsonEvents.size() > 0) {
            throw new RuntimeException(((Event)johnsonEvents.iterator().next()).getDesc());
        }
    }

    @Override
    public void setup(SetupParameters setupParameters, SetupStrategy.StepSwitcher<Step> switcher) throws Exception {
        this.doStepTask(switcher, Step.DATABASE, this::setupDatabase);
        this.doStepTask(switcher, Step.PLUGINS, this::startPlugins);
        this.doStepTask(switcher, Step.ENVIRONMENT, () -> {
            this.importInitialData(setupParameters.getJiraLicenseKey(), setupParameters.getServerId());
            InstantSetupStrategy.setupJiraBaseUrl(setupParameters.getBaseUrl());
        });
        this.doStepTask(switcher, Step.FINISHING, () -> this.upgradeJiraAndFinishSetup(setupParameters, switcher));
    }

    @Override
    public ImmutableMap<Step, SetupStrategy.Status> getInitialSteps() {
        return ImmutableMap.of((Object)((Object)Step.DATABASE), (Object)((Object)SetupStrategy.Status.PENDING), (Object)((Object)Step.PLUGINS), (Object)((Object)SetupStrategy.Status.AWAITING), (Object)((Object)Step.ENVIRONMENT), (Object)((Object)SetupStrategy.Status.AWAITING), (Object)((Object)Step.FINISHING), (Object)((Object)SetupStrategy.Status.AWAITING));
    }

    private void setupDatabase() {
        DatabaseConfigurationManager databaseConfigurationManager = (DatabaseConfigurationManager)ComponentAccessor.getComponent(DatabaseConfigurationManager.class);
        if (!databaseConfigurationManager.isDatabaseSetup()) {
            DatabaseConfig hsqlDatabaseConfiguration = databaseConfigurationManager.getInternalDatabaseConfiguration();
            databaseConfigurationManager.setDatabaseConfiguration(hsqlDatabaseConfiguration);
            databaseConfigurationManager.activateDatabaseWithoutRunningPostDbSetupRunnables();
        }
    }

    private void startPlugins() {
        DatabaseConfigurationManager databaseConfigurationManager = (DatabaseConfigurationManager)ComponentAccessor.getComponent(DatabaseConfigurationManager.class);
        databaseConfigurationManager.runPostDbSetupRunnables();
    }

    private void importInitialData(String jiraLicenseKey, String serverId) {
        DatabaseInitialImporter databaseInitialImporter = (DatabaseInitialImporter)ComponentAccessor.getComponent(DatabaseInitialImporter.class);
        databaseInitialImporter.importInitialData(null, (Option<String>)Option.option((Object)serverId), (Option<String>)Option.option((Object)jiraLicenseKey));
        ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
        applicationProperties.setOption("jira.setup.is.instant", true);
        applicationProperties.setString("jira.title", "JIRA");
        applicationProperties.setString("jira.mode", "private");
    }

    private void upgradeJiraAndFinishSetup(SetupParameters setupParameters, SetupStrategy.StepSwitcher switcher) throws Exception {
        ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
        applicationProperties.setString("jira.setup", "true");
        applicationProperties.setOption("jira.option.user.externalmanagement", false);
        applicationProperties.setOption("jira.option.voting", true);
        applicationProperties.setOption("jira.option.watching", true);
        applicationProperties.setOption("jira.option.issuelinking", true);
        applicationProperties.setString("jira.option.emailvisible", "show");
        UpgradeManager.Status status = ((UpgradeManager)ComponentAccessor.getComponent(UpgradeManager.class)).doUpgradeIfNeededAndAllowed(null, UpgradeManagerParams.builder().withSetupMode().build());
        if (!status.successful()) {
            Iterables.first(status.getErrors()).foreach(switcher::setError);
            throw new RuntimeException("Upgrade has failed");
        }
        try {
            ComponentAccessor.getSubTaskManager().enableSubTasks();
        }
        catch (CreateException e) {
            log.error((Object)"Error encountered when trying to enable sub tasks", (Throwable)e);
            throw new RuntimeException(e);
        }
        FieldLayoutManager fieldLayoutManager = ComponentAccessor.getFieldLayoutManager();
        EditableDefaultFieldLayout editableDefaultFieldLayout = fieldLayoutManager.getEditableDefaultFieldLayout();
        List fieldLayoutItems = editableDefaultFieldLayout.getFieldLayoutItems();
        for (FieldLayoutItem fieldLayoutItem : fieldLayoutItems) {
            RenderableField field;
            if (!(fieldLayoutItem.getOrderableField() instanceof RenderableField) || !(field = (RenderableField)fieldLayoutItem.getOrderableField()).isRenderable()) continue;
            editableDefaultFieldLayout.setRendererType(fieldLayoutItem, "atlassian-wiki-renderer");
        }
        fieldLayoutManager.storeEditableDefaultFieldLayout(editableDefaultFieldLayout);
        ComponentAccessor.getPluginEventManager().broadcast((Object)new JiraStartedEvent());
        InstantSetupStrategy.setCorrectLocale(setupParameters.getLocale());
        UserService.CreateUserValidationResult result = InstantSetupStrategy.createAdministrator(setupParameters.getCredentials());
        if (!result.isValid()) {
            String errorMessage = StringUtils.isEmpty((String)setupParameters.getCredentials().get("email")) ? InstantSetupStrategy.getText("setup.finishing.error.create.administrator.empty.email") : (StringUtils.isEmpty((String)setupParameters.getCredentials().get("password")) ? InstantSetupStrategy.getText("setup.finishing.error.create.administrator.empty.password") : InstantSetupStrategy.getText("setup.finishing.error.create.administrator.generic", setupParameters.getCredentials().get("email")));
            switcher.setError(errorMessage);
            throw new RuntimeException(errorMessage);
        }
        applicationProperties.setString("jira.setup.instant.user", result.getUsername());
    }

    public static final class SetupParameters {
        private final String jiraLicenseKey;
        private final String baseUrl;
        private final String serverId;
        private final Map<String, String> credentials;
        private final String locale;

        private SetupParameters(String jiraLicenseKey, String baseUrl, String serverId, Map<String, String> credentials, String locale) {
            this.jiraLicenseKey = jiraLicenseKey;
            this.baseUrl = baseUrl;
            this.serverId = serverId;
            this.credentials = credentials;
            this.locale = locale;
        }

        public static SetupParametersBuilder builder() {
            return new SetupParametersBuilder();
        }

        public String getJiraLicenseKey() {
            return this.jiraLicenseKey;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public String getServerId() {
            return this.serverId;
        }

        public Map<String, String> getCredentials() {
            return this.credentials;
        }

        public String getLocale() {
            return this.locale;
        }

        public static class SetupParametersBuilder {
            private String jiraLicenseKey;
            private String baseUrl;
            private String serverId;
            private Map<String, String> credentials;
            private String locale;

            private SetupParametersBuilder() {
            }

            public SetupParametersBuilder setJiraLicenseKey(String jiraLicenseKey) {
                this.jiraLicenseKey = jiraLicenseKey;
                return this;
            }

            public SetupParametersBuilder setBaseUrl(String baseUrl) {
                this.baseUrl = baseUrl;
                return this;
            }

            public SetupParametersBuilder setServerId(String serverId) {
                this.serverId = serverId;
                return this;
            }

            public SetupParametersBuilder setCredentials(Map<String, String> credentials) {
                this.credentials = credentials;
                return this;
            }

            public SetupParametersBuilder setLocale(String locale) {
                this.locale = locale;
                return this;
            }

            public SetupParameters build() {
                return new SetupParameters(this.jiraLicenseKey, this.baseUrl, this.serverId, this.credentials, this.locale);
            }
        }
    }

    public static enum Step {
        DATABASE,
        PLUGINS,
        ENVIRONMENT,
        FINISHING;

    }
}

