/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.util.IOUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;

class JiraHomeLockAcquirer {
    private FileOutputStream fileOutputStream;
    private File lockFile;

    JiraHomeLockAcquirer() {
    }

    LockResult acquire(File jiraHomeDir) {
        if (this.fileOutputStream != null) {
            throw new IllegalStateException("You are trying to acquire the lock when this object already has it");
        }
        File lockFile = new File(jiraHomeDir, ".jira-home.lock");
        try {
            FileOutputStream stream = new FileOutputStream(lockFile);
            FileChannel fileChannel = stream.getChannel();
            try {
                FileLock fileLock = fileChannel.tryLock();
                if (fileLock == null) {
                    return LockResult.HELD_BY_OTHERS;
                }
                this.fileOutputStream = stream;
                this.lockFile = lockFile;
                return LockResult.OK;
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                return LockResult.HELD_BY_OTHERS;
            }
            catch (IOException ioe) {
                return LockResult.CANT_CREATE_LOCK;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return LockResult.CANT_CREATE_LOCK;
        }
    }

    void release() {
        IOUtil.shutdownStream(this.fileOutputStream);
        if (this.lockFile != null) {
            this.lockFile.delete();
        }
        this.fileOutputStream = null;
        this.lockFile = null;
    }

    static enum LockResult {
        OK,
        CANT_CREATE_LOCK,
        HELD_BY_OTHERS;

    }
}

