/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.startup.PluginInfo;
import com.atlassian.jira.startup.PluginInfoProvider;
import com.atlassian.jira.startup.PluginInfos;
import com.atlassian.jira.startup.PluginInfosImpl;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class PluginInfoProviderImpl
implements PluginInfoProvider {
    private final PluginAccessor pluginAccessor;
    private final PluginMetadataManager pluginMetadataManager;

    public PluginInfoProviderImpl(PluginAccessor pluginAccessor, PluginMetadataManager pluginMetadataManager) {
        this.pluginAccessor = pluginAccessor;
        this.pluginMetadataManager = pluginMetadataManager;
    }

    public PluginInfos getSystemPlugins() {
        return this.getSystemPlugins(true);
    }

    public PluginInfos getSystemPlugins(boolean includeBuiltInPlugins) {
        Iterable<Plugin> systemPlugins = Iterables.filter((Iterable)this.pluginAccessor.getPlugins(), (Predicate)new SystemPluginPredicate());
        if (!includeBuiltInPlugins) {
            systemPlugins = this.filterOutTrulyBuiltInPlugins(systemPlugins);
        }
        return this.toPluginInfo("System Plugins", systemPlugins);
    }

    public PluginInfos getUserPlugins() {
        Collection plugins = this.pluginAccessor.getPlugins();
        Iterable userPlugins = Iterables.filter((Iterable)plugins, (Predicate)Predicates.not((Predicate)new SystemPluginPredicate()));
        return this.toPluginInfo("User Plugins", userPlugins);
    }

    protected Iterable<Plugin> filterOutTrulyBuiltInPlugins(Iterable<Plugin> pluginInfos) {
        final String[] IGNORE_THOSE_STARTING_WITH = new String[]{"jira.webfragments", "com.atlassian.jira.plugin.wiki", "com.atlassian.jira.plugin.system", "jira.issueviews", "jira.footer", "jira.top.navigation.bar", "jira.webresources"};
        return Iterables.filter(pluginInfos, (Predicate)new Predicate<Plugin>(){

            public boolean apply(@Nullable Plugin pluginInfo) {
                if (pluginInfo != null) {
                    String pluginKey = pluginInfo.getKey();
                    for (String partialKey : IGNORE_THOSE_STARTING_WITH) {
                        if (!StringUtils.defaultString((String)pluginKey).startsWith(partialKey)) continue;
                        return false;
                    }
                }
                return true;
            }
        });
    }

    private PluginInfos toPluginInfo(String name, Iterable<Plugin> plugins) {
        Iterable pluginInfoIterable = Iterables.transform(plugins, (Function)new Function<Plugin, PluginInfo>(){

            public PluginInfo apply(final Plugin plugin) {
                final PluginInformation pluginInformation = plugin.getPluginInformation();
                final PluginState state = plugin.getPluginState();
                final boolean isSystemPlugin = !PluginInfoProviderImpl.this.pluginMetadataManager.isUserInstalled(plugin);
                final boolean unloadablePlugin = plugin instanceof UnloadablePlugin;
                final String unloadbleReason = unloadablePlugin ? ((UnloadablePlugin)plugin).getErrorText() : "";
                return new PluginInfo(){

                    private String nvl(Object o) {
                        return o == null ? "" : String.valueOf(o);
                    }

                    public int getPluginsVersion() {
                        return plugin.getPluginsVersion();
                    }

                    public String getKey() {
                        return this.nvl(plugin.getKey());
                    }

                    public String getName() {
                        return this.nvl(plugin.getName());
                    }

                    public PluginInformation getPluginInformation() {
                        return pluginInformation;
                    }

                    public String getUnloadableReason() {
                        return this.nvl(unloadbleReason);
                    }

                    public boolean isUnloadable() {
                        return unloadablePlugin;
                    }

                    public boolean isEnabled() {
                        return state == PluginState.ENABLED;
                    }

                    public boolean isSystemPlugin() {
                        return isSystemPlugin;
                    }
                };
            }
        });
        ArrayList pluginInfos = Lists.newArrayList((Iterable)pluginInfoIterable);
        Collections.sort(pluginInfos, new Comparator<PluginInfo>(){

            @Override
            public int compare(PluginInfo p1, PluginInfo p2) {
                int rc = p1.getName().compareTo(p2.getName());
                if (rc == 0) {
                    rc = p1.getKey().compareTo(p2.getKey());
                }
                return rc;
            }
        });
        return new PluginInfosImpl(name, pluginInfos);
    }

    private class SystemPluginPredicate
    implements Predicate<Plugin> {
        private SystemPluginPredicate() {
        }

        public boolean apply(@Nullable Plugin input) {
            return !PluginInfoProviderImpl.this.pluginMetadataManager.isUserInstalled(input);
        }
    }
}

