/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.startup.JiraStartupLogger;
import com.atlassian.jira.startup.JiraStartupState;
import com.atlassian.jira.startup.StartupCheck;
import com.google.common.collect.ImmutableList;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.log4j.Level;

@ThreadSafe
public abstract class StartupStateTemplate
implements JiraStartupState {
    private static JiraStartupLogger log = new JiraStartupLogger();
    private final AtomicReference<Future<StartupChecksResult>> startupChecksResult = new AtomicReference();

    @Override
    public boolean isStartupChecksPassed() {
        Future<StartupChecksResult> checkResult = this.startupChecksResult.get();
        if (checkResult == null) {
            FutureTask<StartupChecksResult> newCheckResult = StartupStateTemplate.createFuture(new CreateStartupChecksResult());
            boolean wasNull = this.startupChecksResult.compareAndSet(null, newCheckResult);
            if (wasNull) {
                newCheckResult.run();
                checkResult = newCheckResult;
            } else {
                checkResult = this.startupChecksResult.get();
            }
        }
        try {
            return checkResult.get().validStartup;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception thrown while waiting for future computation", e);
        }
    }

    @Override
    public StartupCheck getFailedStartupCheck() {
        Future<StartupChecksResult> futureCheckResult = this.startupChecksResult.get();
        if (futureCheckResult == null) {
            return null;
        }
        try {
            return futureCheckResult.get().failedStartupCheck;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception thrown while waiting for future computation", e);
        }
    }

    @Override
    public void setFailedStartupCheck(StartupCheck failedStartupCheck) {
        FutureTask<StartupChecksResult> futureTask = StartupStateTemplate.createFuture(new FailedCheckResult(failedStartupCheck));
        this.startupChecksResult.set(futureTask);
        futureTask.run();
    }

    protected abstract ImmutableList<StartupCheck> getStartupChecks();

    private static <T> FutureTask<T> createFuture(Callable<T> callable) {
        return new FutureTask<T>(callable);
    }

    private class StartupChecksResult {
        final boolean validStartup;
        final StartupCheck failedStartupCheck;

        private StartupChecksResult(boolean validStartup, StartupCheck failedStartupCheck) {
            this.validStartup = validStartup;
            this.failedStartupCheck = failedStartupCheck;
        }
    }

    private class FailedCheckResult
    implements Callable<StartupChecksResult> {
        private final StartupCheck failedStartupCheck;

        public FailedCheckResult(StartupCheck failedStartupCheck) {
            this.failedStartupCheck = failedStartupCheck;
        }

        @Override
        public StartupChecksResult call() throws Exception {
            return new StartupChecksResult(false, this.failedStartupCheck);
        }
    }

    private class CreateStartupChecksResult
    implements Callable<StartupChecksResult> {
        private CreateStartupChecksResult() {
        }

        @Override
        public StartupChecksResult call() throws Exception {
            for (StartupCheck startupCheck : StartupStateTemplate.this.getStartupChecks()) {
                if (startupCheck.isOk()) continue;
                log.printMessage(startupCheck.getFaultDescription(), Level.FATAL);
                StartupStateTemplate.this.setFailedStartupCheck(startupCheck);
                return new StartupChecksResult(false, startupCheck);
            }
            return new StartupChecksResult(true, null);
        }
    }
}

