/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.startup.JiraHomePathLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPropertyJiraHomePathLocator
implements JiraHomePathLocator {
    private static final Logger log = LoggerFactory.getLogger(SystemPropertyJiraHomePathLocator.class);

    @Override
    public String getJiraHome() {
        try {
            return JiraSystemProperties.getInstance().getProperty("jira.home");
        }
        catch (SecurityException e) {
            String message = String.format("Unable to obtain JIRA home from system property: %s.", e.getMessage());
            if (log.isDebugEnabled()) {
                log.debug(message, (Throwable)e);
            } else {
                log.info(message);
            }
            return null;
        }
    }

    @Override
    public String getDisplayName() {
        return "System Property";
    }
}

