/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.tenancy;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.tenancy.JiraTenantAccessor;
import com.atlassian.jira.tenancy.JiraTenantImpl;
import com.atlassian.jira.tenancy.TenantInitialDataLoader;
import com.atlassian.jira.tenancy.TenantPluginBridge;
import com.atlassian.jira.tenancy.TenantSetupRegistrar;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ImportUtils;
import com.atlassian.plugins.landlord.spi.LandlordRequestException;
import com.atlassian.plugins.landlord.spi.LandlordRequests;
import com.atlassian.tenancy.api.Tenant;
import com.atlassian.tenancy.api.event.TenantArrivedEvent;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLandlordRequests
implements LandlordRequests,
TenantSetupRegistrar {
    private final EventPublisher eventPublisher;
    private final JiraTenantAccessor jiraTenantAccessor;
    private final TenantPluginBridge tenantPluginBridge;
    private final TimeZoneService timeZoneService;
    private final Set<TenantInitialDataLoader> tenantInitialDataLoaders;
    private final JiraProperties jiraProperties;
    private static final Logger log = LoggerFactory.getLogger(DefaultLandlordRequests.class);

    public DefaultLandlordRequests(EventPublisher eventPublisher, JiraTenantAccessor jiraTenantAccessor, TenantPluginBridge tenantPluginBridge, TimeZoneService timeZoneService, JiraProperties jiraProperties) {
        this.eventPublisher = eventPublisher;
        this.jiraTenantAccessor = jiraTenantAccessor;
        this.tenantPluginBridge = tenantPluginBridge;
        this.timeZoneService = timeZoneService;
        this.jiraProperties = jiraProperties;
        this.tenantInitialDataLoaders = Sets.newHashSet();
    }

    public void acceptTenant(String tenantId) throws LandlordRequestException {
        this.acceptTenant(tenantId, Collections.emptyMap());
    }

    public void acceptTenant(String tenantId, Map<String, String> tenantProperties) throws LandlordRequestException {
        JiraTenantImpl tenant = new JiraTenantImpl(tenantId);
        this.jiraTenantAccessor.addTenant(tenant);
        this.updateTimezoneIfProvided(tenantProperties);
        this.tenantPluginBridge.trigger();
        for (TenantInitialDataLoader loader : this.tenantInitialDataLoaders) {
            loader.start(tenant);
        }
        this.eventPublisher.publish((Object)new TenantArrivedEvent((Tenant)tenant));
        log.debug("Tenanted - AcceptTenantCalled");
    }

    public void removeTenant(String tenantId) throws LandlordRequestException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<String> getTenants() {
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)this.jiraTenantAccessor.getAvailableTenants(), (Function)new Function<Tenant, String>(){

            public String apply(@Nullable Tenant tenant) {
                if (tenant instanceof JiraTenantImpl) {
                    return ((JiraTenantImpl)tenant).getId();
                }
                throw new IllegalArgumentException("tenant should be an instance of JiraTenant");
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTenantInitialDataLoader(TenantInitialDataLoader tenantInitialDataLoader) {
        Set<TenantInitialDataLoader> set = this.tenantInitialDataLoaders;
        synchronized (set) {
            this.tenantInitialDataLoaders.add(tenantInitialDataLoader);
        }
        this.initialiseTenantIfAlreadyTenanted(tenantInitialDataLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterTenantInitialDataLoader(TenantInitialDataLoader tenantInitialDataLoader) {
        Set<TenantInitialDataLoader> set = this.tenantInitialDataLoaders;
        synchronized (set) {
            this.tenantInitialDataLoaders.remove(tenantInitialDataLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAll() {
        Set<TenantInitialDataLoader> set = this.tenantInitialDataLoaders;
        synchronized (set) {
            this.tenantInitialDataLoaders.clear();
        }
    }

    private void initialiseTenantIfAlreadyTenanted(TenantInitialDataLoader tenantInitialDataLoader) {
        for (Tenant tenant : this.jiraTenantAccessor.getAvailableTenants()) {
            tenantInitialDataLoader.start(tenant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTimezoneIfProvided(Map<String, String> tenantProperties) {
        String timezone = tenantProperties.get("timezone");
        if (null != timezone) {
            boolean wasSubvertSecurityScheme = ImportUtils.isSubvertSecurityScheme();
            try {
                ImportUtils.setSubvertSecurityScheme((boolean)true);
                ApplicationUser noUser = null;
                JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(noUser);
                this.timeZoneService.setDefaultTimeZone(timezone, (JiraServiceContext)serviceContext);
                TimeZoneInfo tzInfo = this.timeZoneService.getDefaultTimeZoneInfo((JiraServiceContext)serviceContext);
                this.setJvmAndJodaDefaultTimezone(tzInfo);
            }
            finally {
                ImportUtils.setSubvertSecurityScheme((boolean)wasSubvertSecurityScheme);
            }
        }
    }

    private void setJvmAndJodaDefaultTimezone(TimeZoneInfo tzInfo) {
        this.jiraProperties.setProperty("user.timezone", (Object)tzInfo.getTimeZoneId());
        TimeZone.setDefault(tzInfo.toTimeZone());
        DateTimeZone.setDefault((DateTimeZone)DateTimeZone.forTimeZone((TimeZone)tzInfo.toTimeZone()));
    }
}

