/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.upgrade.BuildNumComparator;
import com.atlassian.jira.upgrade.BuildVersionImpl;
import com.atlassian.jira.upgrade.BuildVersionRegistry;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InjectableComponent
public class DefaultBuildVersionRegistry
implements BuildVersionRegistry {
    private static final Logger log = LoggerFactory.getLogger(DefaultBuildVersionRegistry.class);
    private static final String BUILD_VERSIONS_PROPERTIES = "build-versions.properties";
    private final Map<String, String> buildVersionProperties;
    private final BuildUtilsInfo buildUtilsInfo;

    public DefaultBuildVersionRegistry(BuildUtilsInfo buildUtilsInfo) {
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.buildVersionProperties = new TreeMap<String, String>(new BuildNumComparator());
        this.loadBuildVersions();
    }

    @Override
    public BuildVersionRegistry.BuildVersion getVersionForBuildNumber(String targetBuildNumber) {
        Integer targetBuildInt;
        Assertions.notBlank((String)"targetBuildNumber", (String)targetBuildNumber);
        try {
            targetBuildInt = Integer.valueOf(targetBuildNumber);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
        if (this.buildVersionProperties.containsKey(targetBuildNumber)) {
            String version = this.buildVersionProperties.get(targetBuildNumber);
            return new BuildVersionImpl(targetBuildNumber, version);
        }
        for (String buildNumberKeyString : this.buildVersionProperties.keySet()) {
            Integer buildNumberKey = Integer.valueOf(buildNumberKeyString);
            if (buildNumberKey < targetBuildInt) continue;
            String version = this.buildVersionProperties.get(buildNumberKeyString);
            return new BuildVersionImpl(buildNumberKeyString, version);
        }
        return new BuildVersionImpl(this.buildUtilsInfo.getCurrentBuildNumber(), this.buildUtilsInfo.getVersion());
    }

    @Override
    public BuildVersionRegistry.BuildVersion getBuildNumberForVersion(@Nonnull String targetVersion) {
        for (Map.Entry<String, String> entry : this.buildVersionProperties.entrySet()) {
            if (!entry.getValue().equals(targetVersion)) continue;
            return new BuildVersionImpl(entry.getKey(), entry.getValue());
        }
        return new BuildVersionImpl("2147483647", targetVersion);
    }

    private void loadBuildVersions() {
        Properties props = new Properties();
        InputStream in = ClassLoaderUtils.getResourceAsStream((String)BUILD_VERSIONS_PROPERTIES, DefaultBuildVersionRegistry.class);
        try {
            props.load(in);
            in.close();
            for (Object o : props.keySet()) {
                String key = (String)o;
                this.buildVersionProperties.put(key, props.getProperty(key));
            }
        }
        catch (IOException e) {
            log.error("Unable to load build versions properties from 'build-versions.properties'.");
        }
    }
}

