/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.entity.GenericValueFunctions;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenStore;
import com.atlassian.jira.issue.label.CachingLabelStore;
import com.atlassian.jira.issue.search.CachingSearchRequestStore;
import com.atlassian.jira.issue.search.ClauseRenamingCloningVisitor;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.portal.CachingPortletConfigurationStore;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.FixedSized;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericModelException;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build552
extends LegacyImmediateUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build552.class);
    public static final String CF_ENTITY = "CustomField";
    public static final String CF_VALUE_ENTITY = "CustomFieldValue";
    private static final String FIELD_LAYOUT_ITEM_ENTITY = "FieldLayoutItem";
    private static final String FIELD_SCREEN_LAYOUT_ITEM_ENTITY = "FieldScreenLayoutItem";
    private static final String FIELD_IDENTIFIER = "fieldidentifier";
    public static final String LABELS_CF_KEY = "com.atlassian.jira.plugin.labels:labels";
    public static final String LABEL_GADGET = "rest/gadgets/1.0/g/com.atlassian.jira.plugin.labels:labels-gadget/templates/plugins/labels/gadget/labels-gadget.xml";
    public static final String NEW_LABEL_GADGET = "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:labels-gadget/gadgets/labels-gadget.xml";
    private final OfBizDelegator ofBizDelegator;
    private final LocaleManager localeManager;
    private final ColumnLayoutManager columnLayoutManager;
    private final JqlQueryParser jqlQueryParser;
    private final JqlStringSupport jqlStringSupport;
    private final CustomFieldManager customFieldManager;
    private final I18nHelper.BeanFactory beanFactory;
    private final FieldScreenSchemeManager fieldScreenSchemeManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final FieldScreenStore fieldScreenStore;
    private final CachingLabelStore cachingLabelStore;
    private final CachingSearchRequestStore cachingSearchRequestStore;
    private final CachingPortletConfigurationStore cachingPortletConfigurationStore;
    private final List<GenericValue> fieldsToConvertToSystemGvs = new ArrayList<GenericValue>();

    public UpgradeTask_Build552(OfBizDelegator ofBizDelegator, LocaleManager localeManager, ColumnLayoutManager columnLayoutManager, JqlQueryParser jqlQueryParser, JqlStringSupport jqlStringSupport, CustomFieldManager customFieldManager, I18nHelper.BeanFactory beanFactory, FieldScreenSchemeManager fieldScreenSchemeManager, FieldLayoutManager fieldLayoutManager, FieldScreenStore fieldScreenStore, CachingLabelStore cachingLabelStore, CachingSearchRequestStore cachingSearchRequestStore, CachingPortletConfigurationStore cachingPortletConfigurationStore) {
        this.ofBizDelegator = ofBizDelegator;
        this.localeManager = localeManager;
        this.columnLayoutManager = columnLayoutManager;
        this.jqlQueryParser = jqlQueryParser;
        this.jqlStringSupport = jqlStringSupport;
        this.customFieldManager = customFieldManager;
        this.beanFactory = beanFactory;
        this.fieldScreenSchemeManager = fieldScreenSchemeManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.fieldScreenStore = fieldScreenStore;
        this.cachingLabelStore = cachingLabelStore;
        this.cachingSearchRequestStore = cachingSearchRequestStore;
        this.cachingPortletConfigurationStore = cachingPortletConfigurationStore;
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        List customFieldGVs = this.ofBizDelegator.findByAnd(CF_ENTITY, MapBuilder.singletonMap((Object)"customfieldtypekey", (Object)LABELS_CF_KEY));
        if (!customFieldGVs.isEmpty()) {
            ArrayList<Long> fieldsToConvertToSystem = new ArrayList<Long>();
            ArrayList<Long> customFieldIds = new ArrayList<Long>();
            CustomFieldNameMatchingPredicate fieldNamePredicate = new CustomFieldNameMatchingPredicate("Labels", "issue.field.labels", this.localeManager, this.beanFactory);
            for (GenericValue customFieldGV : customFieldGVs) {
                if (fieldNamePredicate.evaluate(customFieldGV)) {
                    this.fieldsToConvertToSystemGvs.add(customFieldGV);
                    fieldsToConvertToSystem.add(customFieldGV.getLong("id"));
                }
                customFieldIds.add(customFieldGV.getLong("id"));
            }
            log.info((Object)"Migrating labels custom field data to new table...");
            this.migrateCustomFieldData(fieldsToConvertToSystem, customFieldIds);
            log.info((Object)"Migrating labels custom field data to new table...DONE");
            if (!fieldsToConvertToSystem.isEmpty()) {
                log.info((Object)"Updating field screens and field configurations with new system field...");
                this.updateFieldScreensWithSystemField(fieldsToConvertToSystem);
                log.info((Object)"Updating field screens and field configurations with new system field...DONE");
                log.info((Object)"Updating issue navigator columns to use the new labels system field...");
                this.updateIssueNavigatorColumns(fieldsToConvertToSystem);
                log.info((Object)"Updating issue navigator columns to use the new labels system field...DONE");
                log.info((Object)"Updating saved filters to use the new labels system field...");
                this.updateSearchRequests();
                log.info((Object)"Updating saved filters to use the new labels system field...DONE");
                log.info((Object)"Updating label gadgets use the new labels system field...");
                this.updateGadgetConfigurations(fieldsToConvertToSystem);
                log.info((Object)"Updating label gadgets use the new labels system field...DONE");
            }
            log.info((Object)"Converting labels custom fields to new system custom fields...");
            this.ofBizDelegator.bulkUpdateByAnd(CF_ENTITY, (Map)FieldMap.build((String)"customfieldtypekey", (Object)"com.atlassian.jira.plugin.system.customfieldtypes:labels").add("customfieldsearcherkey", (Object)"com.atlassian.jira.plugin.system.customfieldtypes:labelsearcher"), (Map)FieldMap.build((String)"customfieldtypekey", (Object)LABELS_CF_KEY));
            log.info((Object)"Converting labels custom fields to new system custom fields...DONE");
            log.info((Object)"Removing label custom fields that were converted to system fields...");
            for (Long customFieldId : fieldsToConvertToSystem) {
                try {
                    this.customFieldManager.removeCustomFieldPossiblyLeavingOrphanedData(customFieldId);
                }
                catch (RemoveException e) {
                    throw new RuntimeException("Error removing customfield '" + customFieldId + "'", e);
                }
            }
            log.info((Object)"Removing label custom fields that were converted to system fields...DONE");
            log.info((Object)"Cleaning up custom field values table...");
            this.ofBizDelegator.removeByOr(CF_VALUE_ENTITY, "customfield", customFieldIds);
            log.info((Object)"Cleaning up custom field values table...DONE");
            this.customFieldManager.refresh();
            this.cachingLabelStore.onClearCache(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFieldScreensWithSystemField(List<Long> fieldIdsToConvertToSystem) {
        try {
            for (Long customFieldId : fieldIdsToConvertToSystem) {
                this.ofBizDelegator.bulkUpdateByAnd(FIELD_LAYOUT_ITEM_ENTITY, MapBuilder.singletonMap((Object)FIELD_IDENTIFIER, (Object)"labels"), MapBuilder.singletonMap((Object)FIELD_IDENTIFIER, (Object)("customfield_" + customFieldId)));
                this.ofBizDelegator.bulkUpdateByAnd(FIELD_SCREEN_LAYOUT_ITEM_ENTITY, MapBuilder.singletonMap((Object)FIELD_IDENTIFIER, (Object)"labels"), MapBuilder.singletonMap((Object)FIELD_IDENTIFIER, (Object)("customfield_" + customFieldId)));
            }
            this.removeDuplicateLayoutItems(FIELD_LAYOUT_ITEM_ENTITY, "fieldlayout");
            this.removeDuplicateLayoutItems(FIELD_SCREEN_LAYOUT_ITEM_ENTITY, "fieldscreentab");
        }
        finally {
            this.fieldLayoutManager.refresh();
            this.fieldScreenStore.refresh();
            this.fieldScreenSchemeManager.refresh();
        }
    }

    private void removeDuplicateLayoutItems(String table, String relatedTable) {
        ArrayList<Long> itemIdsToRemove = new ArrayList<Long>();
        HashSet<Long> existingRelationIds = new HashSet<Long>();
        List itemGVs = this.ofBizDelegator.findByAnd(table, MapBuilder.singletonMap((Object)FIELD_IDENTIFIER, (Object)"labels"));
        for (GenericValue itemGv : itemGVs) {
            Long relationId = itemGv.getLong(relatedTable);
            if (existingRelationIds.contains(relationId)) {
                itemIdsToRemove.add(itemGv.getLong("id"));
                continue;
            }
            existingRelationIds.add(relationId);
        }
        if (!itemIdsToRemove.isEmpty()) {
            try {
                this.ofBizDelegator.removeByOr(table, "id", itemIdsToRemove);
            }
            catch (GenericModelException e) {
                throw new RuntimeException(e);
            }
        }
    }

    void updateGadgetConfigurations(List<Long> fieldsToConvertToSystem) throws GenericEntityException {
        List labelsGadgetGVs = this.ofBizDelegator.findByLike("PortletConfiguration", MapBuilder.singletonMap((Object)"gadgetXml", (Object)LABEL_GADGET));
        List labelGadgetIds = CollectionUtil.transform((Iterable)labelsGadgetGVs, (Function)GenericValueFunctions.getLong("id"));
        if (!labelGadgetIds.isEmpty()) {
            EntityConditionList entityCondition = new EntityConditionList(Arrays.asList(new EntityExpr("portletconfiguration", EntityOperator.IN, (Object)labelGadgetIds), new EntityExpr("userprefkey", EntityOperator.EQUALS, (Object)"fieldId")), EntityOperator.AND);
            List userPrefGVs = this.ofBizDelegator.findByCondition("GadgetUserPreference", (EntityCondition)entityCondition, null);
            for (GenericValue userPrefGV : userPrefGVs) {
                String value = userPrefGV.getString("userprefvalue");
                Long id = CustomFieldUtils.getCustomFieldId((String)value);
                if (id == null || !fieldsToConvertToSystem.contains(id)) continue;
                userPrefGV.setString("userprefvalue", "labels");
                userPrefGV.store();
            }
            this.ofBizDelegator.bulkUpdateByPrimaryKey("PortletConfiguration", MapBuilder.singletonMap((Object)"gadgetXml", (Object)NEW_LABEL_GADGET), labelGadgetIds);
            this.cachingPortletConfigurationStore.onClearCache(null);
        }
    }

    void updateIssueNavigatorColumns(List<Long> fieldsToConvertToSystem) {
        try {
            LinkedHashMap<Long, Long> layoutItemsToChange = new LinkedHashMap<Long, Long>();
            ArrayList<Long> layoutItemsToRemove = new ArrayList<Long>();
            this.getColumnLayoutItemsToProcess(fieldsToConvertToSystem, layoutItemsToChange, layoutItemsToRemove);
            if (!layoutItemsToRemove.isEmpty()) {
                this.ofBizDelegator.removeByOr("ColumnLayoutItem", "id", layoutItemsToRemove);
            }
            if (!layoutItemsToChange.isEmpty()) {
                this.ofBizDelegator.bulkUpdateByPrimaryKey("ColumnLayoutItem", MapBuilder.newBuilder((Object)FIELD_IDENTIFIER, (Object)"labels").toMap(), new ArrayList(layoutItemsToChange.keySet()));
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        finally {
            this.columnLayoutManager.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getColumnLayoutItemsToProcess(List<Long> customFieldIds, Map<Long, Long> layoutItemsToChange, List<Long> layoutItemsToRemove) {
        List customFieldStringIds = CollectionUtil.transform(customFieldIds, (Function)new Function<Long, String>(){

            public String get(Long input) {
                return "customfield_" + input;
            }
        });
        try (OfBizListIterator layoutItemsIterator = null;){
            layoutItemsIterator = this.ofBizDelegator.findListIteratorByCondition("ColumnLayoutItem", (EntityCondition)new EntityExpr(FIELD_IDENTIFIER, EntityOperator.IN, (Object)customFieldStringIds), null, (Collection)Lists.newArrayList((Object[])new String[]{"id", "columnlayout"}), (List)Lists.newArrayList((Object[])new String[]{"columnlayout ASC", "horizontalposition ASC"}), null);
            GenericValue gv = layoutItemsIterator.next();
            while (gv != null) {
                Long layoutId = gv.getLong("columnlayout");
                Long layoutItemId = gv.getLong("id");
                if (layoutItemsToChange.containsValue(layoutId)) {
                    layoutItemsToRemove.add(layoutItemId);
                } else {
                    layoutItemsToChange.put(layoutItemId, layoutId);
                }
                gv = layoutItemsIterator.next();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void migrateCustomFieldData(List<Long> fieldsToConvertToSystem, List<Long> customFieldIds) {
        try (OfBizListIterator iterator = null;){
            iterator = this.ofBizDelegator.findListIteratorByCondition(CF_VALUE_ENTITY, (EntityCondition)new EntityExpr("customfield", EntityOperator.IN, customFieldIds), null, (Collection)Lists.newArrayList((Object[])new String[]{"issue", "customfield", "textvalue"}), null, null);
            GenericValue gv = iterator.next();
            while (gv != null) {
                Long issueId = gv.getLong("issue");
                Long customFieldId = gv.getLong("customfield");
                String[] labels = StringUtils.split((String)gv.getString("textvalue"), (String)" ");
                if (labels != null) {
                    Map params = fieldsToConvertToSystem.contains(customFieldId) ? MapBuilder.newBuilder().add((Object)"issue", (Object)issueId).toMap() : MapBuilder.newBuilder().add((Object)"issue", (Object)issueId).add((Object)"fieldid", (Object)customFieldId).toMap();
                    for (String label : labels) {
                        Map mapWithLabel = MapBuilder.newBuilder().addAll(params).add((Object)"label", (Object)label).toMap();
                        this.ofBizDelegator.createValue("Label", mapWithLabel);
                    }
                }
                gv = iterator.next();
            }
        }
    }

    void updateSearchRequests() throws GenericEntityException {
        List<Long> searchRequestIds = this.getSearchRequestIds();
        Context percentageLogger = this.getSearchRequestPercentageLogger(searchRequestIds);
        ArrayList<Long> batchSearchRequestIds = new ArrayList<Long>();
        for (Long searchRequestId : searchRequestIds) {
            batchSearchRequestIds.add(searchRequestId);
            if (batchSearchRequestIds.size() < 200) continue;
            this.updateSearchRequests(this.getSearchRequestGvsForIds(batchSearchRequestIds), percentageLogger);
            batchSearchRequestIds.clear();
        }
        if (!batchSearchRequestIds.isEmpty()) {
            this.updateSearchRequests(this.getSearchRequestGvsForIds(batchSearchRequestIds), percentageLogger);
            this.cachingSearchRequestStore.onClearCache(null);
        }
    }

    Context getSearchRequestPercentageLogger(List<Long> searchRequestIds) {
        Context percentageLogger = Contexts.builder().sized((Sized)new FixedSized(searchRequestIds.size())).log(log, "Converting search requests to use the new labels system field is {0}% complete.", Level.INFO).build();
        percentageLogger.setName("Converting search requests to use the new labels system field.");
        return percentageLogger;
    }

    List<GenericValue> getSearchRequestGvsForIds(List<Long> batchSearchRequestIds) {
        EntityExpr idCondition = new EntityExpr("id", EntityOperator.IN, batchSearchRequestIds);
        return this.ofBizDelegator.findByCondition("SearchRequest", (EntityCondition)idCondition, null);
    }

    List<Long> getSearchRequestIds() {
        ArrayList<Long> searchRequestIds = new ArrayList<Long>();
        List searchRequestIdGvs = this.ofBizDelegator.findByCondition("SearchRequest", null, (Collection)CollectionBuilder.list((Object[])new String[]{"id"}));
        for (GenericValue searchRequestIdGv : searchRequestIdGvs) {
            searchRequestIds.add(searchRequestIdGv.getLong("id"));
        }
        return searchRequestIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSearchRequests(List<GenericValue> searchRequestGvs, Context percentageLogger) throws GenericEntityException {
        Map<String, String> substitutions = this.getSubstitutions(this.fieldsToConvertToSystemGvs);
        for (GenericValue searchRequestGv : searchRequestGvs) {
            Context.Task task = percentageLogger.start((Object)searchRequestGv);
            try {
                this.updateSearchRequestIfContainsCustomFieldIds(searchRequestGv, substitutions);
            }
            finally {
                task.complete();
            }
        }
    }

    private void updateSearchRequestIfContainsCustomFieldIds(GenericValue searchRequestGv, Map<String, String> substitutions) throws GenericEntityException {
        String jql = searchRequestGv.getString("request");
        String sanitisedJql = jql == null ? "" : jql;
        try {
            Query query = this.jqlQueryParser.parseQuery(sanitisedJql);
            if (query.getWhereClause() != null) {
                ClauseRenamingCloningVisitor renamer = new ClauseRenamingCloningVisitor(substitutions);
                Clause renamedClause = (Clause)query.getWhereClause().accept((ClauseVisitor)renamer);
                if (!renamedClause.equals(query.getWhereClause())) {
                    QueryImpl newQuery = new QueryImpl(renamedClause, query.getOrderByClause(), null);
                    searchRequestGv.setString("request", this.jqlStringSupport.generateJqlString((Query)newQuery));
                    searchRequestGv.store();
                }
            }
        }
        catch (JqlParseException e) {
            log.error((Object)("Error parsing query '" + jql + "'.  The Filter '" + searchRequestGv.getString("name") + "' will not be converted to use the new Labels system field!"));
        }
    }

    Map<String, String> getSubstitutions(List<GenericValue> fieldsToConvertToSystemGvs) {
        HashMap<String, String> substitutions = new HashMap<String, String>();
        for (GenericValue field : fieldsToConvertToSystemGvs) {
            String name = field.getString("name");
            Long id = field.getLong("id");
            substitutions.put(name, "labels");
            substitutions.put("cf[" + id + "]", "labels");
        }
        return substitutions;
    }

    @Override
    public String getShortDescription() {
        return "Converts label custom fields to the new label system field.";
    }

    @Override
    public String getBuildNumber() {
        return "552";
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "551";
    }

    static class CustomFieldNameMatchingPredicate
    implements Predicate<GenericValue> {
        private final Set<String> labelNames = new HashSet<String>();

        public CustomFieldNameMatchingPredicate(String name, String i18nKey, LocaleManager localeManager, I18nHelper.BeanFactory beanFactory) {
            this.labelNames.add(name);
            for (Locale locale : localeManager.getInstalledLocales()) {
                this.labelNames.add(beanFactory.getInstance(locale).getText(i18nKey));
            }
        }

        public boolean evaluate(GenericValue input) {
            String cfName = input.getString("name");
            return this.labelNames.contains(cfName);
        }
    }
}

