/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build6122
extends LegacyImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build6122.class);

    @Override
    public String getBuildNumber() {
        return "6122";
    }

    @Override
    public String getShortDescription() {
        return "Remove the VCS Update Service, now managed inside the jira-cvs-plugin.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        OfBizDelegator delegator = UpgradeTask_Build6122.getOfBizDelegator();
        List serviceConfigs = delegator.findByAnd("ServiceConfig", (Map)FieldMap.build((String)"name", (Object)"VCS Update Service"));
        if (!serviceConfigs.isEmpty()) {
            if (serviceConfigs.size() > 1) {
                log.error("Should not be more than one VCS Update Service present.");
                return;
            }
            GenericValue serviceConfigGV = (GenericValue)serviceConfigs.get(0);
            log.info("Removing VCS Update Service with id: " + serviceConfigGV.getLong("id"));
            OFBizPropertyUtils.removePropertySet(serviceConfigGV);
            serviceConfigGV.remove();
            ServiceManager component = (ServiceManager)ComponentAccessor.getComponent(ServiceManager.class);
            log.info("Cleaning ServiceManager cache");
            component.refreshAll();
        }
    }
}

