/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import com.google.common.collect.ImmutableList;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build6302
extends LegacyImmediateUpgradeTask {
    static final List<String> DEPRECATED_JOB_GROUPS = ImmutableList.of((Object)"SEND_SUBSCRIPTION");
    static final List<String> DEPRECATED_TRIGGER_GROUPS = ImmutableList.of((Object)"SEND_SUBSCRIPTION");
    static final List<String> LOCK_NAMES = ImmutableList.of((Object)"TRIGGER_ACCESS", (Object)"JOB_ACCESS", (Object)"CALENDAR_ACCESS", (Object)"STATE_ACCESS", (Object)"MISFIRE_ACCESS");
    private final OfBizDelegator delegator;
    private final ServiceManager serviceManager;

    public UpgradeTask_Build6302(OfBizDelegator delegator, ServiceManager serviceManager) {
        this.delegator = delegator;
        this.serviceManager = serviceManager;
    }

    @Override
    public String getBuildNumber() {
        return "6302";
    }

    @Override
    public String getShortDescription() {
        return "Upgrading quartz scheduler tables";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        this.upgradeJobDetails();
        this.upgradeTriggers();
        this.upgradeSimpleTriggers();
        this.upgradeCronTriggers();
        this.addLocks();
        this.serviceManager.refreshAll();
    }

    private void upgradeJobDetails() throws GenericEntityException {
        this.delegator.removeByCondition("JQRTZJobDetails", null);
        List jobDetails = this.delegator.findAll("QRTZJobDetails");
        for (GenericValue jobDetail : jobDetails) {
            if (DEPRECATED_JOB_GROUPS.contains(jobDetail.getString("jobGroup"))) continue;
            FieldMap values = new FieldMap();
            values.putAll((Map)jobDetail);
            values.remove((Object)"id");
            Boolean isDurable = Boolean.valueOf(jobDetail.getString("isDurable"));
            values.put((Object)"isDurable", (Object)isDurable);
            values.put((Object)"isVolatile", (Object)false);
            Boolean isStateful = Boolean.valueOf(jobDetail.getString("isStateful"));
            values.put((Object)"isStateful", (Object)isStateful);
            values.put((Object)"requestsRecovery", (Object)Boolean.FALSE);
            values.remove((Object)"jobData");
            this.delegator.makeValue("JQRTZJobDetails", (Map)values).create();
        }
    }

    private void upgradeTriggers() throws GenericEntityException {
        this.delegator.removeByCondition("JQRTZTriggers", null);
        List jobTriggers = this.delegator.findAll("QRTZTriggers");
        for (GenericValue jobTrigger : jobTriggers) {
            if (DEPRECATED_TRIGGER_GROUPS.contains(jobTrigger.getString("triggerGroup"))) continue;
            FieldMap values = new FieldMap();
            values.putAll((Map)jobTrigger);
            GenericValue job = this.delegator.findById("QRTZJobDetails", jobTrigger.getLong("job"));
            if (job == null) continue;
            values.remove((Object)"id");
            values.remove((Object)"job");
            values.put((Object)"schedName", (Object)"JIRA_scheduler");
            values.put((Object)"jobName", (Object)job.getString("jobName"));
            values.put((Object)"jobGroup", (Object)job.getString("jobGroup"));
            values.put((Object)"isVolatile", (Object)false);
            values.put((Object)"nextFireTime", (Object)this.toSeconds(values.get((Object)"nextFire")));
            values.remove((Object)"nextFire");
            values.put((Object)"startTime", (Object)this.toSeconds(values.get((Object)"startTime")));
            values.put((Object)"endTime", (Object)this.toSeconds(values.get((Object)"endTime")));
            values.put((Object)"description", (Object)(job.getString("jobName") + job.getString("jobGroup")));
            values.put((Object)"triggerState", (Object)"NORMAL");
            this.delegator.makeValue("JQRTZTriggers", (Map)values).create();
        }
    }

    private Long toSeconds(Object aDate) {
        return aDate == null ? null : Long.valueOf(((Timestamp)aDate).getTime());
    }

    private void upgradeSimpleTriggers() throws GenericEntityException {
        this.delegator.removeByCondition("JQRTZSimpleTriggers", null);
        List jobSimpleTriggers = this.delegator.findAll("QRTZSimpleTriggers");
        for (GenericValue jobSimpleTrigger : jobSimpleTriggers) {
            FieldMap values = new FieldMap();
            values.putAll((Map)jobSimpleTrigger);
            GenericValue trigger = this.delegator.findById("QRTZTriggers", jobSimpleTrigger.getLong("trigger"));
            if (trigger == null || DEPRECATED_TRIGGER_GROUPS.contains(trigger.getString("triggerGroup"))) continue;
            values.remove((Object)"id");
            values.remove((Object)"trigger");
            values.put((Object)"triggerName", (Object)trigger.getString("triggerName"));
            values.put((Object)"triggerGroup", (Object)trigger.getString("triggerGroup"));
            this.delegator.makeValue("JQRTZSimpleTriggers", (Map)values).create();
        }
    }

    private void upgradeCronTriggers() throws GenericEntityException {
        this.delegator.removeByCondition("JQRTZCronTriggers", null);
        List jobCronTriggers = this.delegator.findAll("QRTZCronTriggers");
        for (GenericValue jobCronTrigger : jobCronTriggers) {
            FieldMap values = new FieldMap();
            values.putAll((Map)jobCronTrigger);
            GenericValue trigger = this.delegator.findById("QRTZTriggers", jobCronTrigger.getLong("trigger"));
            if (trigger == null || DEPRECATED_TRIGGER_GROUPS.contains(trigger.getString("triggerGroup"))) continue;
            values.remove((Object)"id");
            values.remove((Object)"trigger");
            values.put((Object)"triggerName", (Object)trigger.getString("triggerName"));
            values.put((Object)"triggerGroup", (Object)trigger.getString("triggerGroup"));
            this.delegator.makeValue("JQRTZCronTriggers", (Map)values).create();
        }
    }

    private void addLocks() throws GenericEntityException {
        this.delegator.removeByCondition("JQRTZLocks", null);
        for (String lockName : LOCK_NAMES) {
            this.delegator.makeValue("JQRTZLocks", (Map)FieldMap.build((String)"lockName", (Object)lockName)).create();
        }
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "6301";
    }
}

