/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build755
extends LegacyImmediateUpgradeTask {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeTask_Build755.class);
    static final String AVATAR_ENTITY = "Avatar";
    static final String AVATAR_TYPE = "avatarType";
    static final String OWNER = "owner";
    static final String SYSTEM_AVATAR = "systemAvatar";
    static final Integer NOT_SYSTEM = 0;
    private final OfBizDelegator delegator;

    public UpgradeTask_Build755(OfBizDelegator delegator) {
        this.delegator = delegator;
    }

    @Override
    public String getBuildNumber() {
        return "755";
    }

    @Override
    public String getShortDescription() {
        return "JRA-26194: usernames in AvatarStore should be stored lower case only. Update the storage.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        List avatars = this.delegator.findByAnd(AVATAR_ENTITY, (Map)FieldMap.build((String)SYSTEM_AVATAR, (Object)NOT_SYSTEM, (String)AVATAR_TYPE, (Object)Avatar.Type.USER.getName()));
        if (avatars == null) {
            return;
        }
        LOG.info(String.format("Analysing %d Avatars...", avatars.size()));
        for (GenericValue gv : avatars) {
            String lowercase_owner;
            String owner = gv.getString(OWNER);
            if (owner == null || owner.equals(lowercase_owner = IdentifierUtils.toLowerCase((String)owner))) continue;
            gv.setString(OWNER, lowercase_owner);
            try {
                gv.store();
            }
            catch (GenericEntityException e) {
                throw new DataAccessException((Throwable)e);
            }
        }
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "754";
    }
}

