/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.CachingUserHistoryStore;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.UserIssueSearcherHistoryManager;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.List;

public class DefaultUserIssueSearcherHistoryManager
implements UserIssueSearcherHistoryManager {
    private final UserHistoryManager userHistoryManager;
    private ApplicationProperties applicationProperties;

    public DefaultUserIssueSearcherHistoryManager(UserHistoryManager userHistoryManager, ApplicationProperties applicationProperties) {
        this.userHistoryManager = userHistoryManager;
        this.applicationProperties = applicationProperties;
    }

    public void addIssueSearcherToHistory(ApplicationUser user, IssueSearcher searcher) {
        Assertions.notNull((String)"searcher", (Object)searcher);
        this.userHistoryManager.addItemToHistory(UserHistoryItem.ISSUESEARCHER, user, searcher.getSearchInformation().getId());
    }

    public List<UserHistoryItem> getUserIssueSearcherHistory(ApplicationUser user) {
        List history = this.userHistoryManager.getHistory(UserHistoryItem.ISSUESEARCHER, user);
        int max = CachingUserHistoryStore.getMaxItems(UserHistoryItem.ISSUESEARCHER, this.applicationProperties);
        if (history.size() > max) {
            return history.subList(0, max);
        }
        return history;
    }
}

