/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.util.dbc.Assertions;
import com.opensymphony.module.propertyset.PropertySet;
import javax.annotation.Nonnull;

public class DefaultUserPropertyManager
implements UserPropertyManager {
    private static final String ENTITY_TYPE = "ApplicationUser";
    private final UserKeyStore userKeyStore;
    private final JiraPropertySetFactory propertySetFactory;

    public DefaultUserPropertyManager(UserKeyStore userKeyStore, JiraPropertySetFactory propertySetFactory) {
        this.userKeyStore = userKeyStore;
        this.propertySetFactory = propertySetFactory;
    }

    @Nonnull
    public PropertySet getPropertySet(@Nonnull ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        return this.getPropertySetForUserKey(user.getKey());
    }

    @Nonnull
    public PropertySet getPropertySetForUserKey(@Nonnull String userKey) {
        Long id = this.userKeyStore.getIdForUserKey((String)Assertions.notNull((String)"userKey", (Object)userKey));
        if (id == null) {
            throw new IllegalStateException("There is no ID mapped for the user key '" + userKey + '\'');
        }
        return this.propertySetFactory.buildCachingPropertySet(ENTITY_TYPE, id);
    }
}

