/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.issue.search.SearchException;
import com.opensymphony.util.TextUtils;
import javax.annotation.Nonnull;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;

public class ExceptionUtil {
    public static String getMessage(Throwable ex) {
        StringBuilder sb = new StringBuilder();
        ExceptionUtil.appendExceptionMessageOrClassName(ex, sb);
        if (ex.getCause() != null) {
            sb.append(" caused by: ");
            ExceptionUtil.appendExceptionMessageOrClassName(ex.getCause(), sb);
        }
        return sb.toString();
    }

    public static String logExceptionWithWarn(@Nonnull Logger log, String message, @Nonnull Throwable ex) {
        String logMessage = message + " Exception: " + ExceptionUtil.getMessage(ex);
        log.warn(logMessage);
        if (log.isDebugEnabled()) {
            log.debug("", ex);
        }
        return logMessage;
    }

    public static String logExceptionWithWarn(@Nonnull org.apache.log4j.Logger log, String message, @Nonnull Throwable ex) {
        String logMessage = message + " Exception: " + ExceptionUtil.getMessage(ex);
        log.warn((Object)logMessage);
        if (log.isDebugEnabled()) {
            log.debug((Object)ex);
        }
        return logMessage;
    }

    private static void appendExceptionMessageOrClassName(Throwable ex, StringBuilder sb) {
        if (ex.getMessage() != null) {
            sb.append(ex.getMessage());
        } else {
            sb.append(ex.getClass().getSimpleName());
        }
    }

    public static String getExceptionAsHtml(SearchException e) {
        return TextUtils.plainTextToHtml((String)ExceptionUtils.getFullStackTrace((Throwable)e));
    }
}

