/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;

public class GlobalPermissionGroupAssociationUtil {
    public static final Transformer GROUP_TO_GROUPNAME = new Transformer(){

        public Object transform(Object object) {
            return ((Group)object).getName();
        }
    };
    private final GlobalPermissionManager globalPermissionManager;
    private final GroupManager groupManager;

    public GlobalPermissionGroupAssociationUtil(GlobalPermissionManager globalPermissionManager, GroupManager groupManager) {
        this.globalPermissionManager = globalPermissionManager;
        this.groupManager = groupManager;
    }

    public boolean isRemovingAllMySysAdminGroups(Collection<String> groupsToLeave, ApplicationUser user) {
        Collection<String> sysAdminGroups = this.getSysAdminMemberGroups(user);
        sysAdminGroups.removeAll(groupsToLeave);
        return sysAdminGroups.isEmpty();
    }

    public Collection<String> getSysAdminMemberGroups(ApplicationUser user) {
        return this.getMemberGroupNames(user, 44);
    }

    public boolean isRemovingAllMyAdminGroups(Collection<String> groupsToLeave, ApplicationUser user) {
        Collection<String> startingAdminGroups = this.getAdminMemberGroups(user);
        startingAdminGroups.removeAll(groupsToLeave);
        return startingAdminGroups.isEmpty();
    }

    public Collection<String> getAdminMemberGroups(ApplicationUser user) {
        return this.getMemberGroupNames(user, 0);
    }

    public boolean isUserAbleToDeleteGroup(ApplicationUser user, String groupName) {
        return this.globalPermissionManager.hasPermission(44, user) || !this.globalPermissionManager.getGroupNames(44).contains(groupName);
    }

    public List<String> getGroupNamesModifiableByCurrentUser(ApplicationUser currentUser, Collection<String> groupNames) {
        Collection sysAdminGroupNames;
        ArrayList<String> visibleGroups;
        ArrayList<String> arrayList = visibleGroups = groupNames != null ? new ArrayList<String>(groupNames) : new ArrayList();
        if (!this.globalPermissionManager.hasPermission(44, currentUser) && (sysAdminGroupNames = this.globalPermissionManager.getGroupNames(44)) != null) {
            visibleGroups.removeAll(sysAdminGroupNames);
        }
        Collections.sort(visibleGroups);
        return visibleGroups;
    }

    public List<Group> getGroupsModifiableByCurrentUser(ApplicationUser currentUser, List<Group> groups) {
        Collection sysAdminGroups;
        ArrayList<Group> visibleGroups;
        ArrayList<Object> arrayList = visibleGroups = groups != null ? new ArrayList<Group>(groups) : new ArrayList();
        if (!this.globalPermissionManager.hasPermission(44, currentUser) && (sysAdminGroups = this.globalPermissionManager.getGroupsWithPermission(44)) != null) {
            visibleGroups.removeAll(sysAdminGroups);
        }
        Collections.sort(visibleGroups);
        return visibleGroups;
    }

    public List<Group> getNonAdminGroups(List<Group> groups) {
        ArrayList<Group> visibleGroups = groups != null ? new ArrayList<Group>(groups) : new ArrayList();
        Collection sysAdminGroups = this.globalPermissionManager.getGroupsWithPermission(44);
        if (sysAdminGroups != null) {
            visibleGroups.removeAll(sysAdminGroups);
        }
        Collection adminGroups = this.globalPermissionManager.getGroupsWithPermission(0);
        if (sysAdminGroups != null) {
            visibleGroups.removeAll(adminGroups);
        }
        Collections.sort(visibleGroups);
        return visibleGroups;
    }

    Collection<String> getMemberGroupNames(ApplicationUser user, int permissionType) {
        Collection permissionTypeGroups = this.globalPermissionManager.getGroupNames(permissionType);
        Collection userGroups = this.groupManager.getGroupNamesForUser(user);
        if (userGroups == null) {
            return Collections.emptyList();
        }
        return CollectionUtils.intersection((Collection)userGroups, (Collection)permissionTypeGroups);
    }
}

