/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.thread;

import com.atlassian.jira.cache.request.RequestCacheController;
import com.atlassian.jira.issue.index.DefaultIndexManager;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.util.ImportUtils;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.jira.web.filters.ThreadLocalQueryProfiler;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.TransactionUtil;

public class JiraThreadLocalUtils {
    public static void preCall() {
        JiraAuthenticationContextImpl.clearRequestCache();
        RequestCacheController.startContext();
        ThreadLocalQueryProfiler.start();
    }

    public static void postCall(@Nonnull Logger log, @Nullable JiraThreadLocalUtil.WarningCallback warningCallback) {
        block10: {
            try {
                ThreadLocalQueryProfiler.end();
            }
            catch (IOException e) {
                log.error((Object)"Unable to call ThreadLocalQueryProfiler.end()", (Throwable)e);
            }
            DefaultIndexManager.flushThreadLocalSearchers();
            if (!ImportUtils.isIndexIssues()) {
                log.error((Object)"Indexing thread local not cleared. Clearing...");
                ImportUtils.setIndexIssues((boolean)true);
            }
            try {
                if (TransactionUtil.getLocalTransactionConnection() == null) break block10;
                try {
                    if (warningCallback != null) {
                        warningCallback.onOpenTransaction();
                    } else {
                        log.error((Object)"Uncommitted database transaction detected.  Closing...");
                    }
                }
                finally {
                    TransactionUtil.closeAndClearThreadLocalConnection();
                }
            }
            catch (Exception t) {
                log.error((Object)"Error while inspecting transaction thread local.", (Throwable)t);
            }
        }
        RequestCacheController.closeContext();
    }
}

