/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.core.util.FileSize;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import webwork.config.Configuration;

@WebSudoRequired
public class ViewAttachmentSettings
extends ProjectActionSupport {
    private final AttachmentPathManager attachmentPathManager;

    public ViewAttachmentSettings(ProjectManager projectManager, PermissionManager permissionManager, AttachmentPathManager attachmentPathManager) {
        super(projectManager, permissionManager);
        this.attachmentPathManager = attachmentPathManager;
    }

    public String getAttachmentPath() {
        return this.getAttachmentPathOf(this.attachmentPathManager);
    }

    public String getPrettyAttachmentSize() {
        return FileSize.format((Long)new Long(Configuration.getString((String)"webwork.multipart.maxSize")));
    }

    public boolean getZipSupport() {
        return this.getApplicationProperties().getOption("jira.attachment.allow.zip.support");
    }

    public boolean isAllowedToBetSet() {
        String flag = this.getApplicationProperties().getDefaultBackedString("jira.attachment.set.allowed");
        return flag != null && Boolean.valueOf(flag) != false;
    }

    private String getAttachmentPathOf(AttachmentPathManager pathManager) {
        if (pathManager.getMode() == AttachmentPathManager.Mode.DISABLED) {
            return "";
        }
        if (pathManager.getUseDefaultDirectory()) {
            return this.getText("admin.attachmentsettings.defaultpath") + " [" + pathManager.getAttachmentPath() + "]";
        }
        return pathManager.getAttachmentPath();
    }
}

