/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.index;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.ImmutableList;
import java.util.Collection;

public class IndexRecoveryUtil {
    static final Interval DEFAULT_INTERVAL = Interval.DAILY;

    public static Interval intervalFromMillis(long delay) {
        if (delay < DateUtils.MINUTE_MILLIS) {
            return DEFAULT_INTERVAL;
        }
        if (delay < DateUtils.HOUR_MILLIS * 2L) {
            return Interval.HOURLY;
        }
        if (delay < DateUtils.DAY_MILLIS * 2L) {
            return Interval.DAILY;
        }
        return Interval.WEEKLY;
    }

    public static Collection<TextOption> getIntervalOptions(I18nHelper i18n) {
        return ImmutableList.of((Object)new TextOption(Interval.HOURLY.name(), i18n.getText("admin.index.recovery.snapshot.interval.hour")), (Object)new TextOption(Interval.DAILY.name(), i18n.getText("admin.index.recovery.snapshot.interval.day")), (Object)new TextOption(Interval.WEEKLY.name(), i18n.getText("admin.index.recovery.snapshot.interval.week")));
    }

    public static String getIntervalOption(Interval interval, I18nHelper i18n) {
        switch (interval) {
            case HOURLY: {
                return i18n.getText("admin.index.recovery.snapshot.interval.hour");
            }
            case DAILY: {
                return i18n.getText("admin.index.recovery.snapshot.interval.day");
            }
        }
        return i18n.getText("admin.index.recovery.snapshot.interval.week");
    }

    static enum Interval {
        HOURLY(DateUtils.HOUR_MILLIS),
        DAILY(DateUtils.DAY_MILLIS),
        WEEKLY(DateUtils.DAY_MILLIS * 7L);

        private final long millis;

        private Interval(long millis) {
            this.millis = millis;
        }

        long getMillis() {
            return this.millis;
        }
    }
}

