/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes;

import com.atlassian.fugue.Option;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.IssueTypeService;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.constants.AbstractDeleteConstant;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Lists;
import java.util.Collection;

@WebSudoRequired
public class DeleteIssueType
extends AbstractDeleteConstant<IssueType> {
    private final IssueTypeService issueTypeService;

    public DeleteIssueType(IssueTypeService issueTypeService) {
        this.issueTypeService = issueTypeService;
    }

    @Override
    protected String getConstantEntityName() {
        return "IssueType";
    }

    @Override
    protected String getNiceConstantName() {
        return this.getText("admin.issue.constant.issuetype.lowercase");
    }

    @Override
    protected String getIssueConstantField() {
        return "type";
    }

    @Override
    protected IssueType getConstant(String id) {
        return (IssueType)this.issueTypeService.getIssueType(this.getLoggedInUser(), id).getOrNull();
    }

    protected IssueType getIssueTypeObject() {
        return this.getConstant(this.id);
    }

    @Override
    protected String getRedirectPage() {
        return "ViewIssueTypes.jspa";
    }

    @Override
    protected Collection<IssueType> getConstants() {
        return Lists.newArrayList((Iterable)this.issueTypeService.getIssueTypes(this.getLoggedInUser()));
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshIssueTypes();
        ComponentAccessor.getFieldManager().refresh();
    }

    @Override
    protected void doValidation() {
        IssueTypeService.DeleteValidationResult validationResult = this.issueTypeService.validateDeleteIssueType(this.getLoggedInUser(), new IssueTypeService.IssueTypeDeleteInput(this.id, Option.option((Object)this.newId)));
        if (!validationResult.isValid()) {
            this.addErrorMessages(validationResult.getErrorCollection().getErrorMessages());
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        IssueTypeService.DeleteValidationResult validationResult = this.issueTypeService.validateDeleteIssueType(this.getLoggedInUser(), new IssueTypeService.IssueTypeDeleteInput(this.id, Option.option((Object)this.newId)));
        if (!validationResult.isValid()) {
            return "error";
        }
        this.issueTypeService.deleteIssueType(this.getLoggedInUser(), validationResult);
        return this.getRedirect(this.getRedirectPage());
    }

    public Collection<IssueType> getAvailableIssueTypes() {
        return Lists.newArrayList((Iterable)this.issueTypeService.getAvailableAlternativesForIssueType(this.getLoggedInUser(), this.getIssueTypeObject().getId()));
    }
}

