/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.translation;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueConstantImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.jira.web.util.JiraLocaleUtils;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.StringUtils;

public class TranslationManagerImpl
implements TranslationManager {
    public static final String JIRA_ISSUETYPE_TRANSLATION_PREFIX = "jira.translation.issuetype";
    public static final String JIRA_PRIORITY_TRANSLATION_PREFIX = "jira.translation.priority";
    public static final String JIRA_RESOLUTION_TRANSLATION_PREFIX = "jira.translation.resolution";
    public static final String JIRA_STATUS_TRANSLATION_PREFIX = "jira.translation.status";
    public static final String JIRA_CF_TRANSLATION_PREFIX = "jira.translation.custom.field";
    public static final String NONE = "None";
    private final Map translationPrefixMap;
    private final JiraAuthenticationContext authenticationContext;
    private ApplicationProperties applicationProperties;
    private I18nHelper.BeanFactory beanFactory;

    public TranslationManagerImpl(JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, I18nHelper.BeanFactory beanFactory) {
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
        this.beanFactory = beanFactory;
        this.translationPrefixMap = new HashMap();
        this.translationPrefixMap.put("IssueType", JIRA_ISSUETYPE_TRANSLATION_PREFIX);
        this.translationPrefixMap.put("Priority", JIRA_PRIORITY_TRANSLATION_PREFIX);
        this.translationPrefixMap.put("Resolution", JIRA_RESOLUTION_TRANSLATION_PREFIX);
        this.translationPrefixMap.put("Status", JIRA_STATUS_TRANSLATION_PREFIX);
    }

    public Map getInstalledLocales() {
        ListOrderedMap locales = new ListOrderedMap();
        List<Locale> installedLocales = ((JiraLocaleUtils)((Object)ComponentAccessor.getComponent(JiraLocaleUtils.class))).getInstalledLocales();
        for (int i = 0; i < installedLocales.size(); ++i) {
            Locale locale = installedLocales.get(i);
            locales.put(locale.toString(), locale.getDisplayName(this.authenticationContext.getLocale()));
        }
        return locales;
    }

    public String getTranslatedNameFromString(String translationString) {
        StringTokenizer st = new StringTokenizer(translationString, "\n");
        if (st.countTokens() == 2) {
            return (String)st.nextElement();
        }
        return null;
    }

    public String getTranslatedDescriptionFromString(String translationString) {
        StringTokenizer st = new StringTokenizer(translationString, "\n");
        String extractedDesc = null;
        while (st.hasMoreElements()) {
            extractedDesc = (String)st.nextElement();
        }
        return extractedDesc;
    }

    public String getIssueConstantTranslation(IssueConstant issueConstant, boolean name, String locale, I18nHelper i18n) {
        String translation = this.getTranslationFromDatabase(issueConstant, locale, name);
        if (TextUtils.stringSet((String)translation)) {
            return translation;
        }
        if (TextUtils.stringSet((String)this.getTranslationPrefix(issueConstant))) {
            if (this.isLocaleDifferentThanDefault(locale)) {
                return this.getTranslationFromI18nResources(issueConstant, i18n, name);
            }
            if (this.valueOnIssueConstantIsTheDefault(issueConstant, name)) {
                return this.getTranslationFromI18nResources(issueConstant, i18n, name);
            }
        }
        return name ? issueConstant.getName() : issueConstant.getDescription();
    }

    private String getTranslationFromDatabase(IssueConstant issueConstant, String locale, boolean name) {
        String translationPrefix;
        PropertySet ps = ((IssueConstantImpl)issueConstant).getPropertySet();
        String translationString = ps.getString((translationPrefix = this.getTranslationPrefix(issueConstant)) + issueConstant.getId() + "." + locale);
        if (TextUtils.stringSet((String)translationString)) {
            return name ? this.getTranslatedNameFromString(translationString) : this.getTranslatedDescriptionFromString(translationString);
        }
        return null;
    }

    private boolean isLocaleDifferentThanDefault(String locale) {
        return !this.applicationProperties.getDefaultLocale().toString().equals(locale);
    }

    private String getTranslationFromI18nResources(IssueConstant issueConstant, I18nHelper i18n, boolean name) {
        String key;
        String translation;
        if (i18n == null) {
            i18n = this.authenticationContext.getI18nHelper();
        }
        if ((translation = i18n.getText(key = this.getI18NTranslationKey(issueConstant, name))) != null && !translation.contains(key)) {
            return translation;
        }
        return name ? issueConstant.getName() : issueConstant.getDescription();
    }

    private boolean valueOnIssueConstantIsTheDefault(IssueConstant issueConstant, boolean name) {
        String defaultValue;
        I18nHelper defaultI18n = this.beanFactory.getInstance(Locale.ROOT);
        String key = this.getI18NTranslationKey(issueConstant, name);
        String string = defaultValue = defaultI18n.getResourceBundle().containsKey(key) ? defaultI18n.getResourceBundle().getString(key) : null;
        if (name) {
            return issueConstant.getName() != null && issueConstant.getName().equals(defaultValue);
        }
        return issueConstant.getDescription() != null && issueConstant.getDescription().equals(defaultValue);
    }

    private String getI18NTranslationKey(IssueConstant issueConstant, boolean name) {
        String translationPrefix = this.getTranslationPrefix(issueConstant);
        return translationPrefix + "." + this.makeNameIntoProperty(issueConstant.getName()) + "." + (name ? "name" : "desc");
    }

    public String getIssueConstantTranslation(IssueConstant issueConstant, boolean name, String locale) {
        return this.getIssueConstantTranslation(issueConstant, name, locale, null);
    }

    public boolean hasLocaleTranslation(IssueConstant issueConstant, String locale) {
        PropertySet ps = ((IssueConstantImpl)issueConstant).getPropertySet();
        String issueConstantType = ((IssueConstantImpl)issueConstant).getGenericValue().getEntityName();
        String translationPrefix = this.getTranslationPrefix(issueConstantType);
        String translationString = ps.getString(translationPrefix + issueConstant.getId() + "." + locale);
        return TextUtils.stringSet((String)translationString);
    }

    private String makeNameIntoProperty(String issueConstantName) {
        return StringUtils.deleteWhitespace((String)issueConstantName).toLowerCase();
    }

    private String getTranslationPrefix(String issueConstantType) {
        return (String)this.translationPrefixMap.get(issueConstantType);
    }

    private String getTranslationPrefix(IssueConstant issueConstant) {
        return this.getTranslationPrefix(((IssueConstantImpl)issueConstant).getGenericValue().getEntityName());
    }

    public String getIssueConstantTranslation(IssueConstant issueConstant, boolean name, Locale locale) {
        return this.getIssueConstantTranslation(issueConstant, name, locale.toString());
    }

    public void setIssueConstantTranslation(IssueConstant issueConstant, String issueConstantPrefix, Locale locale, String translatedName, String translatedDesc) {
        PropertySet ps = ((IssueConstantImpl)issueConstant).getPropertySet();
        String issueConstantLocaleKey = issueConstantPrefix + issueConstant.getId() + "." + locale;
        if (TextUtils.stringSet((String)translatedName) && TextUtils.stringSet((String)translatedDesc)) {
            ps.setString(issueConstantLocaleKey, translatedName + "\n" + translatedDesc);
        }
        ComponentAccessor.getConstantsManager().invalidate(issueConstant);
    }

    public void deleteIssueConstantTranslation(IssueConstant issueConstant, String issueConstantPrefix, Locale locale) {
        String issueConstantLocaleKey;
        PropertySet ps = ((IssueConstantImpl)issueConstant).getPropertySet();
        if (ps.exists(issueConstantLocaleKey = issueConstantPrefix + issueConstant.getId() + "." + locale)) {
            ps.remove(issueConstantLocaleKey);
        }
        ComponentAccessor.getConstantsManager().invalidate(issueConstant);
    }

    public String getCustomFieldNameTranslation(CustomField customField) {
        return this.getCustomFieldNameTranslation(customField, this.authenticationContext.getLocale());
    }

    public String getCustomFieldNameTranslation(CustomField customField, Locale locale) {
        PropertySet ps = customField.getPropertySet();
        String nameKey = JIRA_CF_TRANSLATION_PREFIX + customField.getId() + "." + "name" + "." + locale;
        return ps.getString(nameKey);
    }

    public String getCustomFieldDescriptionTranslation(CustomField customField) {
        return this.getCustomFieldDescriptionTranslation(customField, this.authenticationContext.getLocale());
    }

    public String getCustomFieldDescriptionTranslation(CustomField customField, Locale locale) {
        PropertySet ps = customField.getPropertySet();
        String descKey = JIRA_CF_TRANSLATION_PREFIX + customField.getId() + "." + "desc" + "." + locale;
        return ps.getString(descKey);
    }

    public void setCustomFieldTranslation(CustomField customField, Locale locale, String translatedName, String translatedDesc) {
        PropertySet ps = customField.getPropertySet();
        String nameKey = JIRA_CF_TRANSLATION_PREFIX + customField.getId() + "." + "name" + "." + locale;
        if (TextUtils.stringSet((String)translatedName)) {
            ps.setString(nameKey, translatedName);
        } else if (ps.getString(nameKey) != null) {
            ps.remove(nameKey);
        }
        String descKey = JIRA_CF_TRANSLATION_PREFIX + customField.getId() + "." + "desc" + "." + locale;
        if (TextUtils.stringSet((String)translatedDesc)) {
            ps.setString(descKey, translatedDesc);
        } else if (ps.getString(descKey) != null) {
            ps.remove(descKey);
        }
    }

    public void deleteCustomFieldTranslation(CustomField customField, Locale locale) {
        String descKey;
        String nameKey;
        PropertySet ps = customField.getPropertySet();
        if (ps.exists(nameKey = JIRA_CF_TRANSLATION_PREFIX + customField.getId() + "." + "name" + "." + locale)) {
            ps.remove(nameKey);
        }
        if (ps.exists(descKey = JIRA_CF_TRANSLATION_PREFIX + customField.getId() + "." + "desc" + "." + locale)) {
            ps.remove(descKey);
        }
    }
}

