/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.dbc.Null;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPasswordActionHelper {
    private static final Logger log = LoggerFactory.getLogger(UserPasswordActionHelper.class);
    private final JiraWebActionSupport action;
    private final UserUtil userUtil;

    public UserPasswordActionHelper(JiraWebActionSupport action, UserUtil userUtil) {
        this.action = action;
        this.userUtil = userUtil;
    }

    public void setPassword(ApplicationUser user, String newPassword) {
        Null.not("user", user);
        try {
            this.setPasswordImpl(user, newPassword);
        }
        catch (Exception e) {
            String msg = e.getMessage() == null ? "" : e.getMessage();
            log.error("Exception occurred whilst resetting password " + msg, (Throwable)e);
            String errorMessage = this.action.getText("admin.setpassword.osuser.immutable.exception", msg);
            this.action.addErrorMessage(errorMessage);
        }
    }

    void setPasswordImpl(ApplicationUser user, String newPassword) throws PermissionException, UserNotFoundException, InvalidCredentialException {
        try {
            this.userUtil.changePassword(user, newPassword);
        }
        catch (OperationNotPermittedException e) {
            throw new PermissionException((Exception)((Object)e));
        }
    }
}

