/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.google.common.base.Objects;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractWorkflowAction
extends JiraWebActionSupport {
    protected final JiraWorkflow workflow;
    private Long project;
    private String issueType;

    public AbstractWorkflowAction(JiraWorkflow workflow) {
        this.workflow = workflow;
    }

    public JiraWorkflow getWorkflow() {
        return this.workflow;
    }

    public Long getProject() {
        return this.project;
    }

    public void setProject(Long project) {
        this.project = project;
    }

    public String getIssueType() {
        return this.issueType;
    }

    public void setIssueType(String issueType) {
        this.issueType = StringUtils.stripToNull((String)issueType);
    }

    public static String getFullModuleKey(String pluginKey, String moduleKey) {
        if (pluginKey == null && moduleKey == null) {
            return "";
        }
        return pluginKey + (String)Objects.firstNonNull((Object)moduleKey, (Object)"");
    }

    protected String getBasicWorkflowParameters() {
        StringBuilder paramBuilder = new StringBuilder("?workflowName=").append(JiraUrlCodec.encode((String)this.getWorkflow().getName())).append("&workflowMode=").append(this.getWorkflow().getMode());
        if (this.getProject() != null) {
            paramBuilder.append("&project=").append(this.getProject());
        }
        if (this.getIssueType() != null) {
            paramBuilder.append("&issueType=").append(JiraUrlCodec.encode((String)this.getIssueType()));
        }
        return paramBuilder.toString();
    }

    public String getWorkflowDisplayName() {
        return WorkflowUtil.getWorkflowDisplayName((JiraWorkflow)this.workflow);
    }
}

