/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.workflow.AbstractWorkflowTransitionAction;
import com.atlassian.jira.web.action.util.workflow.WorkflowEditorTransitionConditionUtil;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.RestrictionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@WebSudoRequired
public class DeleteWorkflowTransitionCondition
extends AbstractWorkflowTransitionAction {
    private String count;

    public DeleteWorkflowTransitionCondition(JiraWorkflow workflow, StepDescriptor step, ActionDescriptor transition, PluginAccessor pluginAccessor, WorkflowService workflowService) {
        super(workflow, step, transition, pluginAccessor, workflowService);
    }

    public DeleteWorkflowTransitionCondition(JiraWorkflow workflow, ActionDescriptor transition, PluginAccessor pluginAccessor, WorkflowService workflowService) {
        super(workflow, transition, pluginAccessor, workflowService);
    }

    protected void doValidation() {
        if (!TextUtils.stringSet((String)this.getCount())) {
            this.addErrorMessage(this.getText("admin.errors.workflows.invalid.count", "" + this.count));
        }
        this.checkDescriptor();
        if (!this.invalidInput()) {
            List descriptors = this.getDescriptorCollection();
            if (descriptors == null || descriptors.isEmpty()) {
                this.addErrorMessage(this.getText("admin.errors.workflows.no.descriptors.to.delete"));
            } else if (descriptors.size() < this.getConditionIndex()) {
                this.addErrorMessage(this.getText("admin.errors.workflows.count.too.large", "" + this.getConditionIndex(), "" + descriptors.size()));
            }
        }
    }

    protected void checkDescriptor() {
        RestrictionDescriptor restriction = this.getTransition().getRestriction();
        if (restriction == null) {
            this.addErrorMessage(this.getText("admin.errors.workflows.cannot.delete.condition"));
        }
    }

    protected List getDescriptorCollection() {
        ConditionsDescriptor conditionsDescriptor = this.getConditionsDescriptor();
        return conditionsDescriptor.getConditions();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.deleteWorkflowDescriptor();
        this.workflowService.updateWorkflow(this.getJiraServiceContext(), this.getWorkflow());
        if (this.getStep() == null) {
            return this.getRedirect("ViewWorkflowTransition.jspa" + this.getBasicWorkflowParameters() + "&workflowTransition=" + this.getTransition().getId());
        }
        return this.getRedirect("ViewWorkflowTransition.jspa" + this.getBasicWorkflowParameters() + "&workflowStep=" + this.getStep().getId() + "&workflowTransition=" + this.getTransition().getId());
    }

    public String getWorkflowDescriptorName() {
        return "Condition";
    }

    protected void deleteWorkflowDescriptor() throws WorkflowException {
        WorkflowEditorTransitionConditionUtil wetcu = new WorkflowEditorTransitionConditionUtil();
        wetcu.deleteCondition(this.getTransition(), this.getCount());
    }

    private ConditionsDescriptor getConditionsDescriptor() {
        RestrictionDescriptor restriction = this.getTransition().getRestriction();
        if (restriction != null) {
            WorkflowEditorTransitionConditionUtil wetcu = new WorkflowEditorTransitionConditionUtil();
            return wetcu.getParentConditionsDescriptor(restriction, this.getCount());
        }
        return null;
    }

    private int getConditionIndex() {
        String[] counts = StringUtils.split((String)this.getCount(), (String)".");
        return Integer.parseInt(counts[counts.length - 1]);
    }

    public String getCount() {
        return this.count;
    }

    public void setCount(String count) {
        this.count = count;
    }
}

