/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.visibility.Visibilities;
import com.atlassian.jira.bc.issue.visibility.Visibility;
import com.atlassian.jira.bc.issue.worklog.WorklogInputParameters;
import com.atlassian.jira.bc.issue.worklog.WorklogInputParametersImpl;
import com.atlassian.jira.bc.issue.worklog.WorklogNewEstimateInputParameters;
import com.atlassian.jira.bc.issue.worklog.WorklogNewEstimateResult;
import com.atlassian.jira.bc.issue.worklog.WorklogResult;
import com.atlassian.jira.bc.issue.worklog.WorklogService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.CommentVisibility;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.action.issue.AbstractWorklogAction;
import com.atlassian.jira.web.util.OutlookDateManager;
import java.math.BigDecimal;

public class UpdateWorklog
extends AbstractWorklogAction {
    private Worklog worklog;
    private WorklogResult worklogResult;

    public UpdateWorklog(WorklogService worklogService, CommentService commentService, ProjectRoleManager projectRoleManager, JiraDurationUtils jiraDurationUtils, OutlookDateManager outlookDateManager, FieldVisibilityManager fieldVisibilityManager, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, UserUtil userUtil, FeatureManager featureManager) {
        super(worklogService, commentService, projectRoleManager, jiraDurationUtils, outlookDateManager, fieldVisibilityManager, fieldLayoutManager, rendererManager, userUtil, featureManager);
    }

    public String doDefault() throws Exception {
        this.worklog = this.worklogService.getById(this.getJiraServiceContext(), this.getWorklogId());
        if (this.worklog == null) {
            this.addErrorMessage(this.getText("logwork.error.update.invalid.id", this.getWorklogId() == null ? null : this.getWorklogId().toString()));
            return "error";
        }
        if (!this.worklogService.hasPermissionToUpdate(this.getJiraServiceContext(), this.worklog)) {
            return "securitybreach";
        }
        BigDecimal hoursPerDay = this.getHoursPerDay();
        BigDecimal daysPerWeek = this.getDaysPerWeek();
        BigDecimal secondsPerHour = BigDecimal.valueOf(DateUtils.Duration.HOUR.getSeconds());
        long secondsPerDay = hoursPerDay.multiply(secondsPerHour).longValueExact();
        long secondsPerWeek = daysPerWeek.multiply(hoursPerDay).multiply(secondsPerHour).longValueExact();
        this.setTimeLogged(DateUtils.getDurationStringSeconds((long)this.worklog.getTimeSpent(), (long)secondsPerDay, (long)secondsPerWeek));
        this.setStartDate(this.getFormattedStartDate(this.worklog.getStartDate()));
        this.setComment(this.worklog.getComment());
        this.setCommentLevel(CommentVisibility.getCommentLevelFromLevels(this.worklog.getGroupLevel(), this.worklog.getRoleLevelId()));
        return super.doDefault();
    }

    public void doValidation() {
        CommentVisibility commentVisibility = this.getCommentVisibility();
        Visibility visibility = Visibilities.fromGroupAndStrRoleId((String)commentVisibility.getGroupLevel(), (String)commentVisibility.getRoleLevel());
        WorklogInputParametersImpl.Builder builder = WorklogInputParametersImpl.timeSpent((String)this.getTimeLogged()).worklogId(this.getWorklogId()).startDate(this.getParsedStartDate()).comment(this.getComment()).visibility(visibility);
        if ("new".equalsIgnoreCase(this.adjustEstimate)) {
            WorklogNewEstimateInputParameters params = builder.newEstimate(this.getNewEstimate()).buildNewEstimate();
            this.worklogResult = this.worklogService.validateUpdateWithNewEstimate(this.getJiraServiceContext(), params);
        } else {
            WorklogInputParameters params = builder.build();
            this.worklogResult = this.worklogService.validateUpdate(this.getJiraServiceContext(), params);
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if ("auto".equalsIgnoreCase(this.adjustEstimate)) {
            this.worklogService.updateAndAutoAdjustRemainingEstimate(this.getJiraServiceContext(), this.worklogResult, true);
        } else if ("new".equalsIgnoreCase(this.adjustEstimate)) {
            this.worklogService.updateWithNewRemainingEstimate(this.getJiraServiceContext(), (WorklogNewEstimateResult)this.worklogResult, true);
        } else {
            this.worklogService.updateAndRetainRemainingEstimate(this.getJiraServiceContext(), this.worklogResult, true);
        }
        if (this.getHasErrorMessages()) {
            return "error";
        }
        if (this.isInlineDialogMode()) {
            return this.returnComplete();
        }
        return this.getRedirect("/browse/" + this.getIssue().getString("key"));
    }

    public Worklog getWorklog() {
        if (this.worklog == null && this.worklogResult != null) {
            this.worklog = this.worklogResult.getWorklog();
        }
        return this.worklog;
    }

    public boolean isEditMode() {
        return true;
    }
}

