/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.message;

import com.atlassian.adapter.jackson.ObjectMapper;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.message.PopUpMessage;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.Iterables;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public final class MessageResponder {
    private final SoyTemplateRendererProvider rendererProvider;
    private final ObjectMapper objectMapper;

    public MessageResponder(SoyTemplateRendererProvider rendererProvider, ObjectMapper objectMapper) {
        this.rendererProvider = rendererProvider;
        this.objectMapper = objectMapper;
    }

    public final String respond(Iterable<PopUpMessage> messages, URI redirect, JiraWebActionSupport action, String title) {
        if (action.isInlineDialogMode()) {
            return this.respondToAjax(messages, action);
        }
        return this.respondToSubmit(title, messages, redirect, action);
    }

    private String respondToAjax(Iterable<PopUpMessage> messages, JiraWebActionSupport action) {
        String serializedMessages = this.objectMapper.writeValueAsString(messages);
        HttpServletResponse response = action.getHttpResponse();
        response.addHeader("X-Atlassian-Messages", serializedMessages);
        response.setHeader("X-Atlassian-Dialog-Control", "DONE");
        response.setStatus(200);
        return "none";
    }

    private String respondToSubmit(String title, Iterable<PopUpMessage> messages, URI redirect, JiraWebActionSupport action) {
        if (Iterables.isEmpty(messages)) {
            return action.getRedirect(redirect.toString());
        }
        this.renderAcknowledgeView(title, messages, redirect, action);
        return "none";
    }

    private void renderAcknowledgeView(String title, Iterable<PopUpMessage> messages, URI redirect, JiraWebActionSupport action) {
        try {
            HttpServletResponse response = action.getHttpResponse();
            PrintWriter writer = response.getWriter();
            Map data = MapBuilder.newBuilder().add((Object)"title", (Object)title).add((Object)"messages", messages).add((Object)"redirectUri", (Object)redirect.toString()).toMap();
            SoyTemplateRenderer renderer = this.rendererProvider.getRenderer();
            renderer.render((Appendable)writer, "jira.webresources:action-soy-templates", "JIRA.Templates.errors.acknowledge", data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

