/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project;

import com.atlassian.jira.entity.ProjectCategoryFactory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.ofbiz.core.entity.GenericEntityException;

@WebSudoRequired
public class SelectProjectCategory
extends JiraWebActionSupport {
    private Long pid;
    private Long pcid;
    private final ProjectManager projectManager;

    public SelectProjectCategory(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public String doDefault() throws Exception {
        ProjectCategory projectCategory = this.projectManager.getProjectCategoryForProject(this.getProject());
        if (null != projectCategory) {
            this.setPcid(projectCategory.getId());
        } else {
            this.setPcid(-1L);
        }
        return super.doDefault();
    }

    protected void doValidation() {
        if (null == this.getProject()) {
            this.addErrorMessage(this.getText("admin.errors.project.specify.project"));
        }
        if (!new Long(-1L).equals(this.getPcid()) && null == this.getProjectCategory()) {
            this.addError("pcid", this.getText("admin.errors.project.specify.project.category"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.projectManager.setProjectCategory(this.getProject(), this.getProjectCategory());
        return this.returnCompleteWithInlineRedirect("/plugins/servlet/project-config/" + this.getProject().getKey() + "/summary");
    }

    public Collection<ProjectCategory> getProjectCategories() throws GenericEntityException {
        ArrayList projectCategoriesToDisplay = Lists.newArrayList((Object[])new ProjectCategory[]{this.createEmptyProjectCategory()});
        projectCategoriesToDisplay.addAll(this.projectManager.getAllProjectCategories());
        return projectCategoriesToDisplay;
    }

    private ProjectCategory createEmptyProjectCategory() {
        return new ProjectCategoryFactory.Builder().id(-1L).name("None").build();
    }

    public Project getProject() {
        return this.projectManager.getProjectObj(this.getPid());
    }

    private ProjectCategory getProjectCategory() {
        if (null == this.getPcid() || this.getPcid().equals(new Long(-1L))) {
            return null;
        }
        return this.projectManager.getProjectCategoryObject(this.getPcid());
    }

    public Long getPid() {
        return this.pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Long getPcid() {
        return this.pcid;
    }

    public void setPcid(Long pcid) {
        this.pcid = pcid;
    }
}

