/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.search.SharedEntitySearchContext;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.sharing.search.SharedEntitySearchResult;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.user.PortalPageLinkRenderer;
import com.atlassian.jira.web.action.util.PortalPageDisplayBean;
import com.atlassian.jira.web.action.util.portal.PortalPageRetriever;
import com.atlassian.jira.web.action.util.sharing.SharedEntitySearchAction;
import com.atlassian.jira.web.action.util.sharing.SharedEntitySearchViewHelper;
import com.atlassian.jira.web.ui.model.DropDownModel;
import com.atlassian.jira.web.ui.model.DropDownModelBuilder;
import com.atlassian.jira.web.ui.model.DropDownModelProvider;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import webwork.action.ActionContext;
import webwork.action.ServletActionContext;

public class ConfigurePortalPages
extends JiraWebActionSupport
implements SharedEntitySearchAction,
DropDownModelProvider<PortalPageDisplayBean> {
    private static final PortalPageLinkRenderer DASHBOARD_LINK_RENDERER = new PortalPageLinkRenderer(){

        @Override
        public String render(Long id, String name) {
            return "<a href=\"" + ActionContext.getRequest().getContextPath() + "/secure/Dashboard.jspa?selectPageId=" + id + "\">" + TextUtils.htmlEncode((String)name) + "</a>";
        }
    };
    private static final String KEY_NO_SEARCH = "common.sharing.searching.no.search.performed";
    private static final String KEY_NO_RESULTS = "portalpage.no.search.results";
    private static final String CONTENTONLY = "contentonly";
    private final PortalPageService portalPageService;
    private final JiraAuthenticationContext authenticationContext;
    private final FavouritesService favouritesService;
    private final PermissionManager permissionManager;
    private final ShareTypeFactory shareTypeFactory;
    private final PortalPageViewHelper portalPageViewHelper;
    private final UserFormatManager userFormatManager;
    private final WebResourceManager webResourceManager;
    private final PortalPageRetriever portalPageRetriever;
    private String view;
    private String portalPageName;
    private String description;
    private Long copyPageId;
    private int position;
    private String searchEmptyMessageKey = "portalpage.no.search.results";
    private SharedEntitySearchViewHelper.SearchResult<PortalPage> searchResults;
    private List<PortalPageDisplayBean> pages;
    private boolean contentOnly = false;

    public ConfigurePortalPages(PortalPageService portalPageService, JiraAuthenticationContext authenticationContext, FavouritesService favouritesService, PermissionManager permissionManager, ShareTypeFactory shareTypeFactory, UserFormatManager userFormatManager, WebResourceManager webResourceManager, UserHistoryManager userHistoryManager) {
        this.portalPageService = portalPageService;
        this.authenticationContext = authenticationContext;
        this.favouritesService = favouritesService;
        this.permissionManager = permissionManager;
        this.shareTypeFactory = shareTypeFactory;
        this.userFormatManager = userFormatManager;
        this.webResourceManager = webResourceManager;
        this.portalPageRetriever = new PortalPageRetriever(portalPageService, userHistoryManager, authenticationContext);
        this.portalPageViewHelper = new PortalPageViewHelper(this.shareTypeFactory, this.authenticationContext, ActionContext.getRequest().getContextPath(), "ConfigurePortalPages!default.jspa", portalPageService);
    }

    @Override
    public String getSearchName() {
        return this.getPortalPageViewHelper().getSearchName();
    }

    @Override
    public void setSearchName(String searchName) {
        this.getPortalPageViewHelper().setSearchName(searchName);
    }

    @Override
    public String getSearchOwnerUserName() {
        return this.getPortalPageViewHelper().getSearchOwnerUserName();
    }

    @Override
    public void setSearchOwnerUserName(String searchOwnerUserName) {
        this.getPortalPageViewHelper().setSearchOwnerUserName(searchOwnerUserName);
    }

    @Override
    public String getSearchShareType() {
        return this.getPortalPageViewHelper().getSearchShareType();
    }

    @Override
    public void setSearchShareType(String searchShareType) {
        this.getPortalPageViewHelper().setSearchShareType(searchShareType);
    }

    @Override
    public void setGroupShare(String groupShare) {
        this.getPortalPageViewHelper().setGroupShare(groupShare);
    }

    @Override
    public String getGroupShare() {
        return this.getPortalPageViewHelper().getGroupShare();
    }

    @Override
    public Long getPagingOffset() {
        return this.getPortalPageViewHelper().getPagingOffset();
    }

    @Override
    public void setProjectShare(String projectShare) {
        this.getPortalPageViewHelper().setProjectShare(projectShare);
    }

    @Override
    public String getProjectShare() {
        return this.getPortalPageViewHelper().getProjectShare();
    }

    @Override
    public void setRoleShare(String roleShare) {
        this.getPortalPageViewHelper().setRoleShare(roleShare);
    }

    @Override
    public String getRoleShare() {
        return this.getPortalPageViewHelper().getRoleShare();
    }

    @Override
    public void setPagingOffset(Long pagingOffset) {
        this.getPortalPageViewHelper().setPagingOffset(pagingOffset);
    }

    @Override
    public String getSortColumn() {
        return this.getPortalPageViewHelper().getSortColumn();
    }

    @Override
    public void setSortColumn(String sortColumn) {
        this.getPortalPageViewHelper().setSortColumn(sortColumn);
    }

    @Override
    public boolean isSortAscending() {
        return this.getPortalPageViewHelper().isSortAscending();
    }

    @Override
    public void setSortAscending(boolean sortAscending) {
        this.getPortalPageViewHelper().setSortAscending(sortAscending);
    }

    protected void setSearchResults(SharedEntitySearchViewHelper.SearchResult<PortalPage> searchResults) {
        this.searchResults = searchResults;
    }

    public void setPageId(Long pageId) {
        this.portalPageRetriever.setRequestedPageId(pageId);
    }

    public String getPortalPageName() {
        return this.portalPageName;
    }

    public void setPortalPageName(String portalPageName) {
        this.portalPageName = portalPageName;
    }

    public Long getCopyPageId() {
        return this.copyPageId;
    }

    public void setCopyPageId(Long copyPageId) {
        this.copyPageId = copyPageId;
    }

    public Long getPageId() {
        return this.portalPageRetriever.getPageId();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String getPageName(PortalPage portalPage) {
        if (portalPage != null) {
            return portalPage.getName();
        }
        return null;
    }

    public boolean isContentOnly() {
        return this.contentOnly;
    }

    public void setContentOnly(boolean contentOnly) {
        this.contentOnly = contentOnly;
    }

    public String getSearchEmptyMessageKey() {
        return this.searchEmptyMessageKey;
    }

    public PortalPageViewHelper getPortalPageViewHelper() {
        return this.portalPageViewHelper;
    }

    public boolean isSearchRequested() {
        return ActionContext.getParameters().get("Search") != null;
    }

    public PortalPage getCurrentPortalPage() {
        return this.portalPageRetriever.getPortalPage(this.getJiraServiceContext());
    }

    public List getPages() {
        return this.pages;
    }

    protected void setPages(List<PortalPageDisplayBean> pages) {
        this.pages = pages;
    }

    public String getNextUrl() {
        return this.searchResults != null ? this.searchResults.getNextUrl() : null;
    }

    public String getPreviousUrl() {
        return this.searchResults != null ? this.searchResults.getPreviousUrl() : null;
    }

    public int getStartPosition() {
        return this.searchResults != null ? this.searchResults.getStartResultPosition() : -1;
    }

    public int getEndPosition() {
        return this.searchResults != null ? this.searchResults.getEndResultPosition() : -1;
    }

    public int getTotalResultCount() {
        return this.searchResults != null ? this.searchResults.getTotalResultCount() : -1;
    }

    public String doDefault() {
        String tab = StringUtils.isNotBlank((String)this.view) ? this.view : this.getTabFromSession();
        if (this.contentOnly && !this.isValid(tab)) {
            ServletActionContext.getResponse().setStatus(401);
            return "none";
        }
        if (!this.contentOnly) {
            this.webResourceManager.requireResource("jira.webresources:managedashboards");
        }
        if ("search".equalsIgnoreCase(tab)) {
            this.showSearchTab();
        } else if ("popular".equalsIgnoreCase(tab)) {
            this.showPopularTab();
        } else if ("my".equalsIgnoreCase(tab)) {
            this.showMyTab();
        } else if ("favourites".equalsIgnoreCase(tab)) {
            this.showFavouritesTab();
        } else if (this.getLoggedInUser() == null) {
            this.showPopularTab();
        } else {
            this.showFavouritesTab();
        }
        this.storeTabInSession(this.view);
        return this.contentOnly ? CONTENTONLY : "success";
    }

    private boolean isValid(String tab) {
        return this.getLoggedInUser() != null || "my".equals(tab) || "favourites".equals(tab);
    }

    private void showMyTab() {
        this.pages = this.transformToDisplayBeans(this.portalPageService.getOwnedPortalPages(this.getLoggedInUser()));
        this.view = "my";
    }

    private void showFavouritesTab() {
        this.pages = this.transformToDisplayBeans(this.portalPageService.getFavouritePortalPages(this.getLoggedInUser()));
        this.view = "favourites";
    }

    public PortalPageLinkRenderer getPortalPageLinkRenderer() {
        return DASHBOARD_LINK_RENDERER;
    }

    public String doMoveUp() {
        if (this.checkPortalPageId()) {
            return "error";
        }
        JiraServiceContext serviceContext = this.getJiraServiceContext();
        if (this.portalPageService.validateForChangePortalPageSequence(serviceContext, this.portalPageRetriever.getRequestedPageId())) {
            this.portalPageService.increasePortalPageSequence(serviceContext, this.portalPageRetriever.getRequestedPageId());
        }
        if (this.contentOnly) {
            this.showFavouritesTab();
            return CONTENTONLY;
        }
        return this.getRedirect("ConfigurePortalPages!default.jspa");
    }

    public String doMoveDown() {
        if (this.checkPortalPageId()) {
            return "error";
        }
        JiraServiceContext serviceContext = this.getJiraServiceContext();
        if (this.portalPageService.validateForChangePortalPageSequence(serviceContext, this.portalPageRetriever.getRequestedPageId())) {
            this.portalPageService.decreasePortalPageSequence(serviceContext, this.portalPageRetriever.getRequestedPageId());
        }
        if (this.contentOnly) {
            this.showFavouritesTab();
            return CONTENTONLY;
        }
        return this.getRedirect("ConfigurePortalPages!default.jspa");
    }

    public String doMoveToStart() {
        if (this.checkPortalPageId()) {
            return "error";
        }
        JiraServiceContext serviceContext = this.getJiraServiceContext();
        if (this.portalPageService.validateForChangePortalPageSequence(serviceContext, this.portalPageRetriever.getRequestedPageId())) {
            this.portalPageService.moveToStartPortalPageSequence(serviceContext, this.portalPageRetriever.getRequestedPageId());
        }
        if (this.contentOnly) {
            this.showFavouritesTab();
            return CONTENTONLY;
        }
        return this.getRedirect("ConfigurePortalPages!default.jspa");
    }

    public String doMoveToEnd() {
        if (this.checkPortalPageId()) {
            return "error";
        }
        JiraServiceContext serviceContext = this.getJiraServiceContext();
        if (this.portalPageService.validateForChangePortalPageSequence(serviceContext, this.portalPageRetriever.getRequestedPageId())) {
            this.portalPageService.moveToEndPortalPageSequence(serviceContext, this.portalPageRetriever.getRequestedPageId());
        }
        if (this.contentOnly) {
            this.showFavouritesTab();
            return CONTENTONLY;
        }
        return this.getRedirect("ConfigurePortalPages!default.jspa");
    }

    private boolean checkPortalPageId() {
        if (this.portalPageRetriever.getRequestedPageId() == null) {
            this.addErrorMessage(this.getText("admin.errors.user.page.id.must.be.set"));
            return true;
        }
        return false;
    }

    protected List<PortalPageDisplayBean> transformToDisplayBeans(Collection<PortalPage> portalPages) {
        if (portalPages == null || portalPages.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PortalPageDisplayBean> displayBeans = new ArrayList<PortalPageDisplayBean>(portalPages.size());
        for (PortalPage portalPage : portalPages) {
            displayBeans.add(new PortalPageDisplayBean(this.authenticationContext, portalPage, this.favouritesService, this.permissionManager, this.shareTypeFactory, this.userFormatManager));
        }
        return displayBeans;
    }

    private void showSearchTab() {
        boolean searchPerformed = this.isSearchRequested();
        if (searchPerformed) {
            JiraServiceContext ctx = this.getJiraServiceContext();
            this.searchResults = this.getPortalPageViewHelper().search(ctx);
            if (ctx.getErrorCollection().hasAnyErrors()) {
                searchPerformed = false;
            } else {
                this.pages = this.transformToDisplayBeans(this.searchResults.getResults());
            }
        }
        if (!searchPerformed) {
            this.searchEmptyMessageKey = KEY_NO_SEARCH;
        }
        this.view = "search";
    }

    private void showPopularTab() {
        JiraServiceContext serviceContext = this.getJiraServiceContext();
        List<PortalPage> portalPages = this.getPortalPageViewHelper().getPopularFilters(serviceContext);
        if (!serviceContext.getErrorCollection().hasAnyErrors()) {
            this.pages = this.transformToDisplayBeans(portalPages);
        }
        this.view = "popular";
    }

    private void storeTabInSession(String view) {
        ActionContext.getSession().put("jira.configure.pages.tab", view);
    }

    private String getTabFromSession() {
        return (String)ActionContext.getSession().get("jira.configure.pages.tab");
    }

    @Override
    public DropDownModel getDropDownModel(PortalPageDisplayBean displayBean, int listIndex) {
        DropDownModelBuilder builder = DropDownModelBuilder.builder();
        builder.setTopText(this.getText("common.words.operations"));
        builder.startSection();
        if (displayBean.isCurrentOwner()) {
            builder.addItem(builder.item().setText(this.getText("common.words.edit")).setAttr("id", "edit_" + listIndex).setAttr("href", this.toUrl(displayBean, "EditPortalPage!default.jspa", "pageId", true))).addItem(builder.item().setText(this.getText("common.words.delete")).setAttr("id", "delete_" + listIndex).setAttr("class", "delete_dash").setAttr("href", this.toUrl(displayBean, "DeletePortalPage!default.jspa", "pageId", false)));
        }
        builder.addItem(builder.item().setText(this.getText("common.words.copy")).setAttr("id", "clone_" + listIndex).setAttr("href", this.toUrl(displayBean, "AddPortalPage!default.jspa", "clonePageId", false)));
        builder.endSection();
        return builder.build();
    }

    protected String toUrl(PortalPageDisplayBean pageDisplayBean, String page, String idUrlVariable, boolean includeReturnUrl) {
        StringBuilder url = new StringBuilder(page);
        url.append("?" + idUrlVariable + "=").append(pageDisplayBean.getId());
        if (includeReturnUrl && StringUtils.isNotBlank((String)this.getReturnUrl())) {
            url.append("&returnUrl=").append(this.getReturnUrl());
        }
        return this.getUriValidator().getSafeUri("", url.toString());
    }

    protected static class PortalPageViewHelper
    extends SharedEntitySearchViewHelper<PortalPage> {
        private final PortalPageService portalPageService;

        public PortalPageViewHelper(ShareTypeFactory shareTypeFactory, JiraAuthenticationContext authCtx, String applicationContext, String actionUrlPrefix, PortalPageService portalPageService) {
            super(shareTypeFactory, authCtx, applicationContext, actionUrlPrefix, "view", "search", PortalPage.ENTITY_TYPE);
            this.portalPageService = portalPageService;
        }

        @Override
        public SharedEntitySearchContext getEntitySearchContext() {
            return SharedEntitySearchContext.USE;
        }

        @Override
        protected SharedEntitySearchResult<PortalPage> doExecuteSearch(JiraServiceContext ctx, SharedEntitySearchParameters searchParameters, int pageOffset, int pageWidth) {
            return this.portalPageService.search(ctx, searchParameters, pageOffset, pageWidth);
        }

        @Override
        protected boolean validateSearchParameters(JiraServiceContext ctx, SharedEntitySearchParameters searchParameters, int pageOffset, int pageWidth) {
            this.portalPageService.validateForSearch(ctx, searchParameters);
            return !ctx.getErrorCollection().hasAnyErrors();
        }
    }

    private static final class Tab {
        public static final String POPULAR = "popular";
        public static final String SEARCH = "search";
        public static final String FAVOURITES = "favourites";
        public static final String MY = "my";
        public static final String DEFAULT_TAB = "favourites";

        private Tab() {
        }
    }
}

