/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.jira.plugin.aboutpagepanel.AboutPagePanelModuleDescriptor;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;

public class AboutPage
extends JiraWebActionSupport {
    public static final String KEY_COPYRIGHT_SINCE = new String("copyrightSince");
    public static final String KEY_COPYRIGHT_UNTIL = new String("copyrightUntil");
    public static final String KEY_REQUEST_CONTEXT = new String("requestContext");
    public static final String KEY_BUILD_VERSION = new String("buildVersion");
    public static final String KEY_PLUGIN_SECTIONS = new String("pluginModules");
    public static final String KEY_PLUGIN_SECTIONS_EXIST = new String("pluginModulesExist");
    public static final String KEY_LICENSE_SECTION_EXIST = new String("showLicenses");
    public static final String LGPL_TEMPLATE = new String("templates/jira/about/lgpl-libs.soy");
    private static final String FIRST_JIRA_RELEASE_YEAR = "2002";
    private final String copyrightSinceYear;
    private final String copyrightUntilYear;
    private final String buildVersion;
    private final PluginAccessor pluginAccessor;

    public AboutPage(BuildUtilsInfo buildUtilsInfo, PluginAccessor pluginAccessor) {
        this.copyrightSinceYear = FIRST_JIRA_RELEASE_YEAR;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(buildUtilsInfo.getCurrentBuildDate());
        this.copyrightUntilYear = Integer.toString(calendar.get(1));
        this.buildVersion = buildUtilsInfo.getVersion();
        this.pluginAccessor = pluginAccessor;
    }

    @ActionViewData(value="success")
    public Map<String, Object> getData() {
        List<String> pluginSections = this.asHtml();
        boolean showLicenses = ((Object)((Object)this)).getClass().getClassLoader().getResource(LGPL_TEMPLATE) != null;
        return MapBuilder.newBuilder().add((Object)KEY_COPYRIGHT_SINCE, (Object)this.copyrightSinceYear).add((Object)KEY_COPYRIGHT_UNTIL, (Object)this.copyrightUntilYear).add((Object)KEY_REQUEST_CONTEXT, (Object)this.getHttpRequest().getContextPath()).add((Object)KEY_BUILD_VERSION, (Object)this.buildVersion).add((Object)KEY_PLUGIN_SECTIONS, pluginSections).add((Object)KEY_LICENSE_SECTION_EXIST, (Object)showLicenses).add((Object)KEY_PLUGIN_SECTIONS_EXIST, (Object)(!pluginSections.isEmpty() ? 1 : 0)).toMap();
    }

    public List<String> asHtml() {
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(AboutPagePanelModuleDescriptor.class);
        ArrayList result = Lists.newArrayListWithCapacity((int)descriptors.size());
        for (AboutPagePanelModuleDescriptor descriptor : descriptors) {
            result.add(descriptor.getPluginSectionHtml());
        }
        return result;
    }
}

