/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.jira.bc.dataimport.DataImportService;
import com.atlassian.jira.license.LicenseJohnsonEventRaiser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.web.action.util.ImportResultHandler;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;

public class DefaultImportResultHandler
implements ImportResultHandler {
    private final LicenseJohnsonEventRaiser licenseJohnsonEventRaiser;
    private final JohnsonProvider johnsonProvider;

    public DefaultImportResultHandler(LicenseJohnsonEventRaiser licenseJohnsonEventRaiser, JohnsonProvider johnsonProvider) {
        this.licenseJohnsonEventRaiser = licenseJohnsonEventRaiser;
        this.johnsonProvider = johnsonProvider;
    }

    @Override
    public boolean handleErrorResult(DataImportService.ImportResult lastResult, I18nHelper i18n, ErrorCollection errorCollection) {
        switch (lastResult.getImportError()) {
            case UPGRADE_EXCEPTION: {
                JohnsonEventContainer eventCont = this.johnsonProvider.getContainer();
                Event errorEvent = new Event(EventType.get((String)"upgrade"), "An error occurred performing JIRA upgrade task", lastResult.getSpecificErrorMessage(), EventLevel.get((String)"error"));
                if (eventCont != null && !this.licenseJohnsonEventRaiser.checkLicenseIsTooOldForBuild()) {
                    eventCont.addEvent(errorEvent);
                }
                return true;
            }
            case CUSTOM_PATH_EXCEPTION: {
                errorCollection.addErrorMessage(i18n.getText("admin.errors.custom.path", "<a id=\"reimport\" href=\"#\">", "</a>"));
                return false;
            }
            case DOWNGRADE_FROM_ONDEMAND: {
                errorCollection.addErrorMessage(i18n.getText("admin.errors.import.downgrade.error", lastResult.getSpecificErrorMessage(), "<a id='acknowledgeDowngradeError' href='#'>", "</a>"));
                return false;
            }
        }
        return !lastResult.getErrorCollection().hasAnyErrors() && this.checkLicenseIsInvalidOrTooOldForBuild();
    }

    private boolean checkLicenseIsInvalidOrTooOldForBuild() {
        return this.licenseJohnsonEventRaiser.checkLicenseIsTooOldForBuild();
    }
}

