/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.web.component.AbstractWebComponent;
import com.atlassian.plugin.webresource.WebResourceManager;
import java.util.Map;

public class CreateIssueWebComponent
extends AbstractWebComponent {
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;

    public CreateIssueWebComponent(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext) {
        super(templatingEngine, applicationProperties);
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
    }

    public String getHtml(Project project) {
        ApplicationUser user = this.authenticationContext.getUser();
        if (!this.show(project, user)) {
            return "";
        }
        WebResourceManager webResourceManager = ComponentAccessor.getWebResourceManager();
        webResourceManager.requireResource("jira.webresources:jira-global");
        Map<String, Object> velocityParams = JiraVelocityUtils.getDefaultVelocityParams(this.authenticationContext);
        return this.getHtml("templates/jira/multipicker/pickertable.vm", velocityParams);
    }

    boolean show(Project project, ApplicationUser user) {
        return project != null && this.permissionManager.hasPermission(ProjectPermissions.CREATE_ISSUES, project, user);
    }
}

