/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.web.filters.FixedEncodingFilter;
import com.atlassian.jira.web.filters.JiraEncodingFilter;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PathMatchingEncodingFilter
extends AbstractHttpFilter
implements Filter {
    private static final String REST_PATH = "/rest/";
    private final Filter jiraEncodingFilter = new JiraEncodingFilter();
    private final Filter unicodeFilter = new FixedEncodingFilter("UTF-8");

    public void init(FilterConfig filterConfig) throws ServletException {
        this.jiraEncodingFilter.init(filterConfig);
        this.unicodeFilter.init(filterConfig);
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.isRestRequest(request)) {
            this.unicodeFilter.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
        } else {
            this.jiraEncodingFilter.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
        }
    }

    private boolean isRestRequest(HttpServletRequest request) {
        return request.getServletPath() != null && request.getServletPath().startsWith(REST_PATH);
    }

    public void destroy() {
        this.jiraEncodingFilter.destroy();
        this.unicodeFilter.destroy();
    }
}

