/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.tags;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.seraph.util.RedirectUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import webwork.view.taglib.WebWorkBodyTagSupport;

public class LoginLink
extends WebWorkBodyTagSupport {
    private String returnUrl;
    private static final String OS_DESTINATION_TOKEN = "os_destination=";
    private static final Pattern OS_DESTINATION_REGEX = Pattern.compile("[&]*os_destination=[^&]*[&]*");

    public int doEndTag() throws JspException {
        try {
            String body = this.bodyContent.getString();
            this.bodyContent.clearBody();
            String link = this.getLoginLink((HttpServletRequest)this.pageContext.getRequest(), body);
            this.bodyContent.getEnclosingWriter().write(link);
        }
        catch (IOException e) {
            throw new JspException("IOException: " + e);
        }
        return super.doEndTag();
    }

    public String getLoginLink(HttpServletRequest request, String textToLink) {
        StringBuilder link = new StringBuilder();
        link.append("<a class=\"lnk\" rel=\"nofollow\" href=\"");
        link.append(this.getLoginLink(request));
        link.append("\">");
        link.append(textToLink);
        link.append("</a>");
        return link.toString();
    }

    public String getLoginLink(HttpServletRequest request) {
        int start;
        Object returnUrlObj;
        String loginUrl = RedirectUtils.getLinkLoginURL((HttpServletRequest)request);
        if (this.returnUrl != null && (returnUrlObj = this.findValue(this.returnUrl)) != null && returnUrlObj instanceof String && (start = loginUrl.indexOf(OS_DESTINATION_TOKEN)) != -1) {
            return loginUrl.substring(0, start + OS_DESTINATION_TOKEN.length()) + LoginLink.encodeUrl((String)returnUrlObj);
        }
        if (request.getAttribute("jira.logout.page.executed") != null) {
            return this.removeOSDestination(loginUrl);
        }
        return loginUrl;
    }

    private String removeOSDestination(String loginUrl) {
        String url = OS_DESTINATION_REGEX.matcher(loginUrl).replaceAll("");
        if (url.endsWith("?")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    private static String encodeUrl(String url) {
        try {
            return URLEncoder.encode(url, ComponentAccessor.getApplicationProperties().getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

