/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.gadgets.dashboard.Color;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.transformer.CharSequenceDownloadableResource;
import com.atlassian.plugin.webresource.transformer.TransformerParameters;
import com.atlassian.plugin.webresource.transformer.TransformerUrlBuilder;
import com.atlassian.plugin.webresource.transformer.UrlReadingWebResourceTransformer;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformerFactory;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssSubstitutionWebResourceTransformer
implements WebResourceTransformerFactory {
    private static final Logger log = LoggerFactory.getLogger(CssSubstitutionWebResourceTransformer.class);
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("@([a-zA-Z][a-zA-Z0-9_]*)");
    public static final String LOOKNFEEL_VERSION_QUERY_PARAM = "looknfeel_version";
    private final ApplicationProperties applicationProperties;
    private final WebResourceIntegration webResourceIntegration;

    public CssSubstitutionWebResourceTransformer(ApplicationProperties applicationProperties, WebResourceIntegration webResourceIntegration) {
        this.applicationProperties = applicationProperties;
        this.webResourceIntegration = webResourceIntegration;
    }

    public TransformerUrlBuilder makeUrlBuilder(TransformerParameters parameters) {
        return urlBuilder -> urlBuilder.addToHash(LOOKNFEEL_VERSION_QUERY_PARAM, (Object)LookAndFeelBean.getInstance((ApplicationProperties)this.applicationProperties).getSettingsHash());
    }

    public UrlReadingWebResourceTransformer makeResourceTransformer(TransformerParameters parameters) {
        return (transformableResource, params) -> new CssSubstitutionDownloadableResource(transformableResource.nextResource(), LookAndFeelBean.getInstance((ApplicationProperties)this.applicationProperties), this.webResourceIntegration);
    }

    static class CssSubstitutionDownloadableResource
    extends CharSequenceDownloadableResource {
        private final VariableMap variableMap;

        public CssSubstitutionDownloadableResource(DownloadableResource originalResource, LookAndFeelBean lAndF, WebResourceIntegration webResourceIntegration) {
            super(originalResource);
            this.variableMap = new VariableMap(lAndF, webResourceIntegration);
        }

        protected String transform(CharSequence input) {
            Map<String, String> variables = this.variableMap.getVariableMap(true);
            Matcher matcher = VARIABLE_PATTERN.matcher(input);
            int start = 0;
            StringBuilder out = null;
            while (matcher.find()) {
                if (out == null) {
                    out = new StringBuilder();
                }
                out.append(input.subSequence(start, matcher.start()));
                String token = matcher.group(1);
                String subst = variables.get(token);
                if (subst != null) {
                    out.append(subst);
                } else {
                    out.append(matcher.group());
                }
                start = matcher.end();
            }
            if (out == null) {
                return input.toString();
            }
            out.append(input.subSequence(start, input.length()));
            return out.toString();
        }
    }

    public static class VariableMap {
        private final LookAndFeelBean lAndF;
        private final WebResourceIntegration webResourceIntegration;

        public VariableMap(LookAndFeelBean lAndF, WebResourceIntegration webResourceIntegration) {
            this.lAndF = lAndF;
            this.webResourceIntegration = webResourceIntegration;
        }

        public Map<String, String> getVariableMap(boolean addLegacyVars) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            Map<String, Object> beanProperties = this.getLookAndFeelProperties();
            for (Map.Entry<String, Object> entry : beanProperties.entrySet()) {
                String name = entry.getKey();
                Object value = entry.getValue();
                if (!(value instanceof String)) continue;
                String stringValue = (String)value;
                result.put(name, stringValue);
                if (!addLegacyVars) continue;
                result.put(name + "NoHash", StringUtils.strip((String)stringValue, (String)"#"));
            }
            this.addFieldLabelWidthVariables(result, addLegacyVars);
            this.addGadgetColours(result);
            HttpServletRequest httpServletRequest = ExecutingHttpRequest.get();
            if (httpServletRequest != null) {
                result.put("contextPath", httpServletRequest.getContextPath());
            }
            result.put("systemBuildNumber", this.webResourceIntegration.getSystemBuildNumber());
            result.put("systemCounter", this.webResourceIntegration.getSystemCounter());
            return result;
        }

        private void addGadgetColours(Map<String, String> result) {
            for (Color color : Color.values()) {
                if (color.equals((Object)Color.color8)) continue;
                result.put("gadget" + color.name(), this.lAndF.getGadgetChromeColor(color.name()));
            }
        }

        @Deprecated
        private void addFieldLabelWidthVariables(Map<String, String> result, boolean addLegacyVars) {
            String labelWidthStr = this.lAndF.getDefaultBackedString("jira.lf.field.label.width", "9");
            int labelWidth = 9;
            if (StringUtils.isNumeric((String)labelWidthStr)) {
                labelWidth = Integer.parseInt(labelWidthStr);
            }
            result.put("fieldLabelWidth", Integer.toString(labelWidth) + "em");
            if (addLegacyVars) {
                result.put("fieldLabelWidth05", Double.toString((double)labelWidth + 0.5) + "em");
                result.put("fieldLabelWidth10", Integer.toString(labelWidth + 1) + "em");
                result.put("fieldLabelWidth15", Double.toString((double)labelWidth + 1.5) + "em");
                result.put("fieldLabelWidth20", Integer.toString(labelWidth + 2) + "em");
            }
        }

        private Map<String, Object> getLookAndFeelProperties() {
            try {
                return PropertyUtils.describe((Object)this.lAndF);
            }
            catch (Exception e) {
                log.warn("Could not read LookAndFeelBean", (Throwable)e);
                return Collections.emptyMap();
            }
        }
    }
}

