/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;

public class MetalResourcesManager {
    public static Set<String> STATIC_ASSETS = ImmutableSet.of((Object)"/static-assets/metal-all.css", (Object)"/static-assets/metal-all-ie.css", (Object)"/static-assets/metal-all-ie9.css", (Object)"/static-assets/metal-all.js", (Object)"/static-assets/metal-all-ie.js");
    private final String contextPath;
    private final Writer out;

    public static String getMetalResources(String contextPath) {
        StringWriter sw = new StringWriter();
        MetalResourcesManager.includeMetalResources(sw, contextPath);
        return sw.toString();
    }

    public static void includeMetalResources(Writer out, String contextPath) {
        MetalResourcesManager manager = new MetalResourcesManager(contextPath, out);
        MetalResourcesManager.includeMetalResources(manager);
    }

    static void includeMetalResources(MetalResourcesManager metalResourcesManager) {
        try {
            metalResourcesManager.writeStyle("metal-all.css").writeScript("metal-all.js").startIf("lt IE 9").writeStyle("metal-all-ie.css").writeScript("metal-all-ie.js").endIf().startIf("IE 9").writeStyle("metal-all-ie9.css").endIf();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public MetalResourcesManager(String contextPath, Writer out) {
        this.contextPath = contextPath;
        this.out = out;
    }

    public MetalResourcesManager writeStyle(String filename) throws IOException {
        this.out.write("<link type='text/css' rel='stylesheet' href='" + this.resourcePath(filename) + "' media='all'>");
        return this;
    }

    public MetalResourcesManager writeScript(String filename) throws IOException {
        this.out.write("<script src='" + this.resourcePath(filename) + "'></script>");
        return this;
    }

    public MetalResourcesManager startIf(String condition) throws IOException {
        this.out.write("<!--[if " + condition + "]>");
        return this;
    }

    public MetalResourcesManager endIf() throws IOException {
        this.out.write("<![endif]-->");
        return this;
    }

    private String resourcePath(String filename) {
        return this.contextPath + "/static-assets/" + filename;
    }
}

