/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.OSWorkflowConfigurator;
import com.atlassian.jira.workflow.SkippableCondition;
import com.atlassian.jira.workflow.SkippableValidator;
import com.opensymphony.workflow.Condition;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.Register;
import com.opensymphony.workflow.TypeResolver;
import com.opensymphony.workflow.Validator;
import com.opensymphony.workflow.WorkflowException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOSWorkflowConfigurator
implements Startable,
OSWorkflowConfigurator {
    private static final Logger log = LoggerFactory.getLogger(DefaultOSWorkflowConfigurator.class);
    @ClusterSafe
    private final ConcurrentMap<String, TypeResolver> pluginTypeResolvers = new ConcurrentHashMap<String, TypeResolver>();
    private final TypeResolver legacyTypeResolver = new LegacyJiraTypeResolver();

    public void start() throws Exception {
        TypeResolver.setResolver((TypeResolver)new JiraTypeResolverDelegator());
    }

    @Override
    public void registerTypeResolver(String className, TypeResolver typeResolver) {
        Assertions.notNull((String)"className", (Object)className);
        Assertions.notNull((String)"typeResolver", (Object)typeResolver);
        this.pluginTypeResolvers.put(className, typeResolver);
    }

    @Override
    public void unregisterTypeResolver(String className, TypeResolver typeResolver) {
        Assertions.notNull((String)"className", (Object)className);
        Assertions.notNull((String)"typeResolver", (Object)typeResolver);
        this.pluginTypeResolvers.remove(className, typeResolver);
    }

    class LegacyJiraTypeResolver
    extends TypeResolver {
        LegacyJiraTypeResolver() {
        }

        protected Object loadObject(String className) {
            try {
                Class objClass = ClassLoaderUtils.loadClass((String)className.trim(), ((Object)((Object)this)).getClass());
                if (objClass == null) {
                    log.error("Could not load class '" + className + "'");
                    return null;
                }
                return JiraUtils.loadComponent(objClass);
            }
            catch (Exception e) {
                log.error("Could not load class '" + className + "'", (Throwable)e);
                return null;
            }
        }
    }

    class JiraTypeResolverDelegator
    extends TypeResolver {
        JiraTypeResolverDelegator() {
        }

        private TypeResolver getDelegate(Map args) {
            String className = (String)args.get("class.name");
            if (className == null) {
                return null;
            }
            TypeResolver typeResolver = (TypeResolver)DefaultOSWorkflowConfigurator.this.pluginTypeResolvers.get(className);
            if (typeResolver == null) {
                return DefaultOSWorkflowConfigurator.this.legacyTypeResolver;
            }
            return typeResolver;
        }

        public Condition getCondition(String type, Map args) throws WorkflowException {
            TypeResolver delegate = this.getDelegate(args);
            if (delegate == null) {
                return null;
            }
            return SkippableCondition.of(delegate.getCondition(type, args));
        }

        public FunctionProvider getFunction(String type, Map args) throws WorkflowException {
            TypeResolver delegate = this.getDelegate(args);
            if (delegate == null) {
                return null;
            }
            return delegate.getFunction(type, args);
        }

        public Register getRegister(String type, Map args) throws WorkflowException {
            TypeResolver delegate = this.getDelegate(args);
            if (delegate == null) {
                return null;
            }
            return delegate.getRegister(type, args);
        }

        public Validator getValidator(String type, Map args) throws WorkflowException {
            TypeResolver delegate = this.getDelegate(args);
            if (delegate == null) {
                return null;
            }
            return SkippableValidator.of(delegate.getValidator(type, args));
        }
    }
}

