/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowSchemeImpl;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeBuilderTemplate;
import java.util.Date;

public class DraftWorkflowSchemeBuilder
extends WorkflowSchemeBuilderTemplate<DraftWorkflowScheme.Builder>
implements DraftWorkflowScheme.Builder {
    private final ApplicationUser lastModifiedUser;
    private final Date lastModifiedTime;
    private final AssignableWorkflowScheme parent;

    DraftWorkflowSchemeBuilder(DraftWorkflowScheme draftWorkflowScheme) {
        super((WorkflowScheme)draftWorkflowScheme);
        this.lastModifiedUser = draftWorkflowScheme.getLastModifiedUser();
        this.lastModifiedTime = draftWorkflowScheme.getLastModifiedDate();
        this.parent = draftWorkflowScheme.getParentScheme();
    }

    DraftWorkflowSchemeBuilder(AssignableWorkflowScheme parent) {
        super(null, parent.getMappings());
        this.lastModifiedUser = null;
        this.lastModifiedTime = null;
        this.parent = parent;
    }

    @Override
    DraftWorkflowScheme.Builder builder() {
        return this;
    }

    public ApplicationUser getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedTime;
    }

    public AssignableWorkflowScheme getParentScheme() {
        return this.parent;
    }

    public DraftWorkflowScheme build() {
        return new DraftWorkflowSchemeImpl(this.getId(), this.getMappings(), this.lastModifiedUser, this.lastModifiedTime == null ? new Date() : this.lastModifiedTime, this.parent);
    }

    public boolean isDraft() {
        return true;
    }

    public boolean isDefault() {
        return false;
    }

    public String getDescription() {
        return this.parent.getDescription();
    }

    public String getName() {
        return this.parent.getName();
    }
}

