/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.condition;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.workflow.condition.AbstractJiraCondition;
import com.atlassian.jira.workflow.condition.DisallowIfInStepCondition;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowContext;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseCondition
extends AbstractJiraCondition {
    private static final Logger log = LoggerFactory.getLogger(DisallowIfInStepCondition.class);

    public boolean passesCondition(Map transientVars, Map args, PropertySet ps) {
        try {
            Boolean close = (Boolean)transientVars.get("close");
            if (!close.booleanValue()) {
                return false;
            }
            Issue issue = this.getIssue(transientVars);
            WorkflowContext context = (WorkflowContext)transientVars.get("context");
            String username = context.getCaller();
            ApplicationUser user = null;
            if (username != null) {
                user = UserUtils.getUser((String)username);
            }
            return ComponentAccessor.getPermissionManager().hasPermission(18, issue, user);
        }
        catch (Exception e) {
            log.error("Exception: " + e, (Throwable)e);
            return false;
        }
    }
}

