/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.condition;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.WorkflowDescriptorUtil;
import com.atlassian.jira.workflow.condition.AbstractJiraCondition;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Map;

public class PermissionCondition
extends AbstractJiraCondition {
    public boolean passesCondition(Map transientVars, Map args, PropertySet ps) {
        ProjectPermissionKey key = WorkflowDescriptorUtil.resolvePermissionKey(args);
        PermissionManager permissionManager = ComponentAccessor.getPermissionManager();
        if (!permissionManager.getProjectPermission(key).isDefined()) {
            return true;
        }
        ApplicationUser caller = this.getCallerUser(transientVars, args);
        Issue issue = this.getIssue(transientVars);
        return permissionManager.hasPermission(key, issue, caller);
    }
}

