/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity;

import com.google.common.primitives.Primitives;
import java.lang.reflect.Method;

public class VelocityTypesUtil {
    public static final Class<Object> NULL_OBJECT_TYPE = Object.class;
    private static final Class<?>[] EMPTY_ARRAY = new Class[0];

    public static Class<?>[] getMethodArgsTypes(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            return EMPTY_ARRAY;
        }
        Class[] translatedTypes = new Class[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            translatedTypes[i] = VelocityTypesUtil.translateTypes(parameterType);
        }
        return translatedTypes;
    }

    public static Class<?>[] getParametersTypes(Object[] params) {
        if (params == null || params.length == 0) {
            return EMPTY_ARRAY;
        }
        Class[] types = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            types[i] = param == null ? NULL_OBJECT_TYPE : param.getClass();
        }
        return types;
    }

    private static Class<?> translateTypes(Class<?> parameterType) {
        if (parameterType.isPrimitive()) {
            return Primitives.wrap(parameterType);
        }
        return parameterType;
    }
}

