/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.clustering;

import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.license.ClusterLicenseCheck;
import com.atlassian.jira.license.Jira6xServiceDeskPluginEncodedLicenseSupplier;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseCheck;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.util.I18nHelper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterLicenseStartupCheck
implements StartupCheck {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterLicenseStartupCheck.class);
    static final String NAME = "JIRA Cluster License Check";
    static final String FAULT_DESC = "startup.cluster.license.check";
    private final JiraLicenseManager licenseManager;
    private final I18nHelper i18nHelper;
    private final LicenseCheck licenseCheck;
    private final Jira6xServiceDeskPluginEncodedLicenseSupplier serviceDeskLicenseSupplier;
    private LicenseCheck.Result licenseCheckResult;

    public ClusterLicenseStartupCheck(ClusterLicenseCheck licenseCheck, I18nHelper i18nHelper, JiraLicenseManager licenseManager, Jira6xServiceDeskPluginEncodedLicenseSupplier serviceDeskLicenseSupplier) {
        this.licenseManager = licenseManager;
        this.licenseCheck = licenseCheck;
        this.i18nHelper = i18nHelper;
        this.serviceDeskLicenseSupplier = serviceDeskLicenseSupplier;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isOk() {
        LOG.debug("Performing JIRA Cluster License Check");
        this.licenseCheckResult = this.licenseCheck.evaluate();
        return this.licenseCheckResult.isPass() || this.removeNonDataCenterLicenses();
    }

    @Override
    public String getFaultDescription() {
        return this.i18nHelper.getText(FAULT_DESC);
    }

    @Override
    public String getHTMLFaultDescription() {
        return this.getFaultDescription();
    }

    @Override
    public void stop() {
    }

    @Deprecated
    private boolean removeNonDataCenterLicenses() {
        Option<String> serviceDeskLicense;
        assert (this.licenseCheckResult != null) : "removeNonDataCenterLicenses() called before isOk()";
        assert (!this.licenseCheckResult.isPass()) : "removeNonDataCenterLicenses() called when isOk() returned true";
        List<LicenseDetails> failedLicenses = this.licenseCheckResult.getFailedLicenses();
        try {
            this.licenseManager.removeLicenses(failedLicenses);
        }
        catch (Throwable unexpected) {
            LOG.error("Problem encountered while trying to remove DataCenter-incompatible licenses. DataCenter may not be able to start up. If this problem persists, you may need to remove licenses directly from the data store.", unexpected);
            return false;
        }
        if (this.containsServiceDeskPluginLicense(failedLicenses) && (serviceDeskLicense = this.serviceDeskLicenseSupplier.get()).isDefined()) {
            this.serviceDeskLicenseSupplier.moveToUpgradeStore();
        }
        LOG.warn("Some licenses were found to be incompatible with DataCenter and have been removed from this instance");
        return true;
    }

    private boolean containsServiceDeskPluginLicense(List<LicenseDetails> failedLicenses) {
        return failedLicenses.stream().anyMatch(lic -> lic.hasApplication(ApplicationKeys.SERVICE_DESK));
    }
}

