/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationConfigurationEvent;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.application.ApplicationRoleStore;
import com.atlassian.jira.config.group.GroupConfigurationIdentifier;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseChangedEvent;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.message.MessageUtil;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.GlobalPermissionType;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class ApplicationConfigurationHelper {
    private static final Logger log = LoggerFactory.getLogger(ApplicationConfigurationHelper.class);
    private final ApplicationManager applicationManager;
    private final GroupManager groupManager;
    private final ApplicationRoleManager applicationRoleManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final UserManager userManager;
    private final ApplicationRoleStore applicationRoleStore;
    private final MessageUtil.Factory messageUtilFactory;
    private final GroupConfigurationIdentifier groupConfigurationIdentifier;
    private final Supplier<Set<GlobalPermissionType>> globalPermissionTypeSupplier;
    private final EventPublisher eventPublisher;
    private final JiraAuthenticationContext authenticationContext;
    private final JiraLicenseManager licenseManager;
    private final JohnsonProvider johnsonProvider;
    private static final String IMPORT_EVENT_TYPE = "import";

    public ApplicationConfigurationHelper(ApplicationManager applicationManager, GroupManager groupManager, ApplicationRoleManager applicationRoleManager, GlobalPermissionManager globalPermissionManager, UserManager userManager, ApplicationRoleStore applicationRoleStore, MessageUtil.Factory messageUtilFactory, GroupConfigurationIdentifier groupConfigurationIdentifier, EventPublisher eventPublisher, JiraAuthenticationContext authenticationContext, JiraLicenseManager jiraLicenseManager, JohnsonProvider johnsonProvider) {
        this.applicationRoleManager = (ApplicationRoleManager)Assertions.notNull((String)"applicationRoleManager", (Object)applicationRoleManager);
        this.groupManager = (GroupManager)Assertions.notNull((String)"groupManager", (Object)groupManager);
        this.applicationManager = (ApplicationManager)Assertions.notNull((String)"applicationManager", (Object)applicationManager);
        this.globalPermissionManager = (GlobalPermissionManager)Assertions.notNull((String)"globalPermissionManager", (Object)globalPermissionManager);
        this.userManager = (UserManager)Assertions.notNull((String)"userManager", (Object)userManager);
        this.applicationRoleStore = (ApplicationRoleStore)Assertions.notNull((String)"applicationRoleStore", (Object)applicationRoleStore);
        this.messageUtilFactory = (MessageUtil.Factory)Assertions.notNull((String)"messageUtilFactory", (Object)messageUtilFactory);
        this.groupConfigurationIdentifier = (GroupConfigurationIdentifier)Assertions.notNull((String)"groupConfigurationIdentifier", (Object)groupConfigurationIdentifier);
        this.globalPermissionTypeSupplier = new DefaultGlobalPermissionsSupplier();
        this.eventPublisher = (EventPublisher)Assertions.notNull((String)"eventPublisher", (Object)eventPublisher);
        this.authenticationContext = (JiraAuthenticationContext)Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        this.licenseManager = (JiraLicenseManager)Assertions.notNull((String)"jiraLicenseManager", (Object)jiraLicenseManager);
        this.johnsonProvider = (JohnsonProvider)Assertions.notNull((String)"jiraLicenseManager", (Object)johnsonProvider);
    }

    public Optional<String> validateApplicationForConfiguration(ApplicationKey applicationKey, @Nullable ApplicationUser user) {
        MessageUtil msgUtil;
        Assertions.notNull((String)"applicationKey", (Object)applicationKey);
        MessageUtil messageUtil = msgUtil = user != null ? this.messageUtilFactory.getNewInstance(user) : this.messageUtilFactory.getNewInstance();
        if (this.noConfigPermission(user)) {
            return Optional.of(msgUtil.getText("application.installation.configuration.not.admin"));
        }
        if (this.doesApplicationHaveActiveDefaultGroupConfigured(applicationKey)) {
            return Optional.empty();
        }
        String defaultGroupName = this.getAvailableDefaultGroupName(applicationKey).orElse(this.getDefaultGroupName(applicationKey));
        String applicationDisplayName = this.getApplicationDisplayName(applicationKey);
        if (this.groupManager.groupExists(defaultGroupName)) {
            return Optional.of(msgUtil.getText("application.installation.configuration.group.exist", defaultGroupName, applicationDisplayName, msgUtil.getAnchorTagWithInternalLink("app_access_local")));
        }
        if (this.groupConfigurationIdentifier.groupHasExistingConfiguration(defaultGroupName)) {
            return Optional.of(msgUtil.getText("application.installation.configuration.group.config.exist", defaultGroupName, applicationDisplayName, msgUtil.getAnchorTagWithInternalLink("app_access_local")));
        }
        if (!this.userManager.hasGroupWritableDirectory()) {
            return Optional.of(msgUtil.getText("application.installation.configuration.use.to.app", msgUtil.getUrl("user-app-access").getUrl(), applicationDisplayName));
        }
        return Optional.empty();
    }

    public void configureApplicationsForSetup(Collection<Group> additionalGroups, boolean publishEvent) {
        Assertions.notNull((String)"additionalGroups", additionalGroups);
        Set<ApplicationKey> confApps = StreamSupport.stream(this.licenseManager.getLicenses().spliterator(), false).flatMap(licenseDetails -> this.configureApplicationForLicense((LicenseDetails)licenseDetails, Optional.empty()).stream()).collect(Collectors.toSet());
        this.applicationRoleManager.getRoles().forEach(role -> this.addGroupsToRole((ApplicationRole)role, Optional.empty(), Sets.newHashSet((Iterable)additionalGroups), true));
        this.configureAdminGroupsForGlobalPermissions();
        if (publishEvent) {
            this.publishAppConfigEvent(confApps);
        }
    }

    public void configureApplicationsForImport(LicenseDetails licenseDetailsForImport) {
        this.publishAppConfigEvent(this.configureApplicationForLicense(licenseDetailsForImport, Optional.empty()));
    }

    public void setupAdminForDefaultApplications(ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        this.applicationRoleManager.getRoles().forEach(role -> role.getDefaultGroups().forEach(group -> this.addUserToGroup(user, (Group)group)));
    }

    public void configureLicense(LicenseChangedEvent event) {
        if (!this.isImportInProgress()) {
            if (event.getNewLicenseDetails().isDefined()) {
                this.configureApplicationForLicense((LicenseDetails)event.getNewLicenseDetails().get(), Optional.ofNullable(this.authenticationContext.getLoggedInUser()));
            }
            this.publishAppConfigEventForLicense(event);
        }
    }

    private boolean isImportInProgress() {
        JohnsonEventContainer container = this.johnsonProvider.getContainer();
        for (Event event : container.getEvents()) {
            if (!IMPORT_EVENT_TYPE.equals(event.getKey().getType())) continue;
            log.info("Received new license while import in progress, skipping application configuration.");
            return true;
        }
        return false;
    }

    private void publishAppConfigEventForLicense(LicenseChangedEvent event) {
        HashSet configuredApps = Sets.newHashSet();
        if (event.getNewLicenseDetails().isDefined()) {
            configuredApps.addAll(((LicenseDetails)event.getNewLicenseDetails().get()).getLicensedApplications().getKeys());
        }
        if (event.getPreviousLicenseDetails().isDefined()) {
            configuredApps.addAll(((LicenseDetails)event.getPreviousLicenseDetails().get()).getLicensedApplications().getKeys());
        }
        this.publishAppConfigEvent(configuredApps);
    }

    private Set<ApplicationKey> configureApplicationForLicense(LicenseDetails licenseDetails, Optional<ApplicationUser> optionalUser) {
        Assertions.notNull((String)"licenseDetails", (Object)licenseDetails);
        if (!this.userManager.hasGroupWritableDirectory()) {
            log.warn("There are no writable directories to create the default group for the new license.");
            return Collections.emptySet();
        }
        HashSet configuredApps = Sets.newHashSet();
        for (ApplicationKey key : licenseDetails.getLicensedApplications().getKeys()) {
            if (!this.doesApplicationHaveActiveDefaultGroupConfigured(key)) {
                if (this.configureApplicationWithDefaultGroup(key, optionalUser)) {
                    configuredApps.add(key);
                    continue;
                }
                log.info("Unable to perform application configuration for {}.", (Object)key.toString());
                continue;
            }
            log.info("Application already configured for {}.", (Object)key.toString());
        }
        return configuredApps;
    }

    private boolean configureApplicationWithDefaultGroup(ApplicationKey key, Optional<ApplicationUser> optionalUser) {
        log.info("Attempting to perform application configuration for {}.", (Object)key.toString());
        Option roleOption = this.applicationRoleManager.getRole(key);
        if (roleOption.isDefined()) {
            Optional<String> optionGroupName = this.getAvailableDefaultGroupName(key);
            if (!optionGroupName.isPresent()) {
                return false;
            }
            Group defaultGroup = this.getOrCreateGroup(optionGroupName.get());
            if (defaultGroup != null) {
                boolean groupAlreadyConfigured = this.applicationRoleStore.get(key).getDefaultGroups().stream().anyMatch(groupName -> groupName.equals(this.toGroupName(defaultGroup.getName())));
                if (groupAlreadyConfigured) {
                    log.info("Application already {} already configured with group {}.", (Object)key.toString(), (Object)defaultGroup.getName());
                    return false;
                }
                this.addGroupsToRole((ApplicationRole)roleOption.get(), Optional.of(defaultGroup), Collections.emptySet(), false);
                this.configureGroupForGlobalPermissions(defaultGroup);
                optionalUser.ifPresent(user -> this.addUserToGroup((ApplicationUser)user, defaultGroup));
                log.info("Application configured for {}.", (Object)key.toString());
                return true;
            }
        }
        return false;
    }

    private void configureGroupForGlobalPermissions(Group group) {
        ((Set)this.globalPermissionTypeSupplier.get()).forEach(gpt -> this.addPermissionToGroupIfItHasNotBeenGrantedYet((GlobalPermissionType)gpt, group));
    }

    private void addPermissionToGroupIfItHasNotBeenGrantedYet(GlobalPermissionType globalPermissionType, Group group) {
        if (this.globalPermissionManager.getGroupsWithPermission(globalPermissionType.getGlobalPermissionKey()).contains(group)) {
            return;
        }
        this.globalPermissionManager.addPermission(globalPermissionType, this.toGroupName(group.getName()));
    }

    private void configureAdminGroupsForGlobalPermissions() {
        this.globalPermissionManager.getGroupsWithPermission(GlobalPermissionKey.ADMINISTER).forEach(adminGroup -> this.configureGroupForGlobalPermissions((Group)adminGroup));
    }

    private void publishAppConfigEvent(Set<ApplicationKey> confApps) {
        if (!confApps.isEmpty()) {
            this.eventPublisher.publish((Object)new ApplicationConfigurationEvent(confApps));
        }
    }

    private ApplicationRole addGroupsToRole(ApplicationRole role, Optional<Group> defaultGroup, Set<Group> additionalGroups, boolean forceIsSelectedByDefault) {
        HashSet groups = Sets.newHashSet((Iterable)role.getGroups());
        groups.addAll(additionalGroups);
        defaultGroup.ifPresent(groups::add);
        HashSet defaultGroups = Sets.newHashSet((Iterable)role.getDefaultGroups());
        defaultGroup.ifPresent(defaultGroups::add);
        return this.applicationRoleManager.setRole(role.withGroups((Iterable)groups, (Iterable)defaultGroups).withSelectedByDefault(forceIsSelectedByDefault || role.isSelectedByDefault()));
    }

    private boolean noConfigPermission(@Nullable ApplicationUser user) {
        return user != null && !this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    private String getApplicationDisplayName(ApplicationKey applicationKey) {
        return (String)this.applicationManager.getApplication(applicationKey).map(Application::getName).getOrElse(this.applicationRoleManager.getRole(applicationKey).map(ApplicationRole::getName).getOrElse((Object)applicationKey.toString()));
    }

    private Optional<String> getAvailableDefaultGroupName(ApplicationKey applicationKey) {
        String defaultGroupName = this.getDefaultGroupName(applicationKey);
        if (this.isGroupNameAvailable(defaultGroupName)) {
            return Optional.of(defaultGroupName);
        }
        for (int groupCounter = 1; groupCounter <= 5; ++groupCounter) {
            String groupWithInc = String.format("%s-%d", defaultGroupName, groupCounter);
            if (!this.isGroupNameAvailable(groupWithInc)) continue;
            return Optional.of(groupWithInc);
        }
        String dateString = new DateTime().toString(DateTimeFormat.forPattern((String)"yyyyMMdd"));
        for (int i = 1; i <= 999; ++i) {
            String uglyGroupName = String.format("%s-%s-%s-%d", defaultGroupName, "auto", dateString, i);
            if (!this.isGroupNameAvailable(uglyGroupName)) continue;
            return Optional.of(uglyGroupName);
        }
        log.warn(String.format("The default group name [%s] for [%2$s] already exist. Unable to provide an unused group name for [%2$s].", defaultGroupName, this.getApplicationDisplayName(applicationKey)));
        return Optional.empty();
    }

    private boolean isGroupNameAvailable(String defaultGroupName) {
        return !this.groupManager.groupExists(defaultGroupName) && !this.groupConfigurationIdentifier.groupHasExistingConfiguration(defaultGroupName);
    }

    private String getDefaultGroupName(ApplicationKey applicationKey) {
        return this.toGroupName((String)this.applicationManager.getApplication(applicationKey).map(Application::getDefaultGroup).getOrElse(() -> String.format("%s-users", applicationKey.value())));
    }

    private String toGroupName(String groupName) {
        return IdentifierUtils.toLowerCase((String)groupName);
    }

    private boolean doesApplicationHaveActiveDefaultGroupConfigured(ApplicationKey applicationKey) {
        return this.applicationRoleStore.get(applicationKey).getDefaultGroups().stream().anyMatch(arg_0 -> ((GroupManager)this.groupManager).groupExists(arg_0));
    }

    private Group getOrCreateGroup(String groupName) {
        Group group = this.groupManager.getGroup(groupName);
        if (group != null) {
            return group;
        }
        try {
            return this.groupManager.createGroup(groupName);
        }
        catch (InvalidGroupException e) {
            if ("Group already exists".equals(e.getMessage())) {
                return e.getGroup();
            }
            log.warn("Unable to create group during application configuration.", (Throwable)e);
        }
        catch (OperationNotPermittedException e) {
            log.warn("Unable to create group during application configuration.", (Throwable)e);
        }
        return null;
    }

    private void addUserToGroup(ApplicationUser user, Group group) {
        if (!this.groupManager.isUserInGroup(user, group)) {
            try {
                this.groupManager.addUserToGroup(user, group);
            }
            catch (CrowdException e) {
                log.warn("Unable to add user to group during application configuration.", (Throwable)e);
            }
        }
    }

    private class DefaultGlobalPermissionsSupplier
    implements Supplier<Set<GlobalPermissionType>> {
        private DefaultGlobalPermissionsSupplier() {
        }

        public Set<GlobalPermissionType> get() {
            return GlobalPermissionKey.DEFAULT_APP_GLOBAL_PERMISSIONS.stream().map(arg_0 -> ((GlobalPermissionManager)ApplicationConfigurationHelper.this.globalPermissionManager).getGlobalPermission(arg_0)).map(Option::getOrNull).filter(Objects::nonNull).collect(Collectors.toSet());
        }
    }
}

