/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.application.ApplicationKeys;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class UndefinedApplicationRoleName {
    private static final Map<ApplicationKey, UndefinedApplicationRoleName> knownApplications = ImmutableMap.of((Object)ApplicationKeys.SERVICE_DESK, (Object)new UndefinedApplicationRoleName("JIRA Service Desk"), (Object)ApplicationKeys.SOFTWARE, (Object)new UndefinedApplicationRoleName("JIRA Software"), (Object)ApplicationKeys.CORE, (Object)new UndefinedApplicationRoleName("JIRA Core"));
    private String name = "UNKNOWN";

    public static UndefinedApplicationRoleName of(ApplicationKey appId) {
        if (knownApplications.containsKey(appId)) {
            return knownApplications.get(appId);
        }
        return new UndefinedApplicationRoleName(UndefinedApplicationRoleName.deriveName(appId));
    }

    private UndefinedApplicationRoleName(String theName) {
        this.name = theName;
    }

    public String getName() {
        return this.name;
    }

    private static String deriveName(ApplicationKey appId) {
        String[] nameParts = appId.value().split("[-.]");
        StringBuilder convertedName = new StringBuilder();
        for (int index = 0; index < nameParts.length; ++index) {
            String namePart = nameParts[index];
            if (StringUtils.isBlank((CharSequence)namePart)) continue;
            if (namePart.equalsIgnoreCase("jira")) {
                convertedName.append("JIRA ");
                continue;
            }
            convertedName.append(StringUtils.capitalize((String)namePart));
            if (index == nameParts.length - 1) continue;
            convertedName.append(" ");
        }
        return convertedName.toString();
    }
}

