/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingEntry;
import com.atlassian.jira.auditing.AuditingEventListener;
import com.atlassian.jira.auditing.AuditingFilter;
import com.atlassian.jira.auditing.AuditingManager;
import com.atlassian.jira.auditing.AuditingRetentionPeriod;
import com.atlassian.jira.auditing.AuditingStore;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.Records;
import com.atlassian.jira.auditing.handlers.FieldLayoutSchemeChangeHandler;
import com.atlassian.jira.auditing.handlers.GroupEventHandler;
import com.atlassian.jira.auditing.handlers.NotificationChangeHandler;
import com.atlassian.jira.auditing.handlers.PermissionChangeHandler;
import com.atlassian.jira.auditing.handlers.ProjectComponentEventHandler;
import com.atlassian.jira.auditing.handlers.ProjectEventHandler;
import com.atlassian.jira.auditing.handlers.SchemeEventHandler;
import com.atlassian.jira.auditing.handlers.SystemAuditEventHandler;
import com.atlassian.jira.auditing.handlers.UserEventHandler;
import com.atlassian.jira.auditing.handlers.VersionEventHandler;
import com.atlassian.jira.auditing.handlers.WorkflowEventHandler;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.concurrent.BarrierFactory;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.ExecutingHttpRequest;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class AuditingManagerImpl
implements AuditingManager,
Startable {
    private final AuditingStore auditingStore;
    private final ApplicationProperties applicationProperties;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final AuditingEventListener auditingEventListener;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;
    private final BarrierFactory barrierFactory;

    public AuditingManagerImpl(AuditingStore auditingStore, ApplicationProperties applicationProperties, EventPublisher eventPublisher, FeatureManager featureManager, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, PermissionChangeHandler permissionChangeHandler, GroupEventHandler groupEventHandler, SchemeEventHandler schemeEventHandler, UserEventHandler userEventHandler, WorkflowEventHandler workflowEventHandler, NotificationChangeHandler notificationChangeHandler, FieldLayoutSchemeChangeHandler fieldLayoutSchemeChangeHandler, ProjectEventHandler projectEventHandler, BarrierFactory barrierFactory, ProjectComponentEventHandler projectComponentEventHandler, VersionEventHandler versionEventHandler, SystemAuditEventHandler systemAuditEventHandler) {
        this.auditingStore = auditingStore;
        this.applicationProperties = applicationProperties;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
        this.barrierFactory = barrierFactory;
        this.auditingEventListener = new AuditingEventListener(this, permissionChangeHandler, groupEventHandler, schemeEventHandler, userEventHandler, workflowEventHandler, notificationChangeHandler, fieldLayoutSchemeChangeHandler, projectEventHandler, projectComponentEventHandler, versionEventHandler, systemAuditEventHandler, featureManager);
    }

    public void store(RecordRequest record) {
        ApplicationUser author = record.getAuthor() != null ? record.getAuthor() : this.getLoggedInUser();
        AuditingEntry.Builder entry = AuditingEntry.builder(record.getCategory(), record.getSummary(), record.getEventSource()).categoryName(record.getCategoryName()).remoteAddress(StringUtils.defaultString((String)record.getRemoteAddress(), (String)this.getRemoteAddress())).author(author).objectItem(record.getObjectItem()).changedValues((Iterable<ChangedValue>)record.getChangedValues()).associatedItems((Iterable<AssociatedItem>)record.getAssociatedItems()).isAuthorSysAdmin(this.permissionManager.hasPermission(44, author)).description(record.getDescription());
        this.auditingStore.storeRecord(entry.build());
    }

    @Nonnull
    public Records getRecords(@Nullable Long maxId, @Nullable Long sinceId, @Nullable Integer maxResults, @Nullable Integer offset, @Nullable AuditingFilter filter) {
        return this.getRecords(maxId, sinceId, maxResults, offset, filter, true);
    }

    @Nonnull
    public Records getRecordsWithoutSysAdmin(@Nullable Long maxId, @Nullable Long sinceId, @Nullable Integer maxResults, @Nullable Integer offset, @Nullable AuditingFilter filter) {
        return this.getRecords(maxId, sinceId, maxResults, offset, filter, false);
    }

    public long countRecords(@Nullable Long maxId, @Nullable Long sinceId) {
        return this.countRecords(maxId, sinceId, true);
    }

    public long countRecordsWithoutSysAdmin(@Nullable Long maxId, @Nullable Long sinceId) {
        return this.countRecords(maxId, sinceId, false);
    }

    protected Records getRecords(@Nullable Long maxId, @Nullable Long sinceId, @Nullable Integer maxResults, Integer offset, @Nullable AuditingFilter filter, boolean includeSysAdminActions) {
        this.barrierFactory.getBarrier("auditingGetRecords").await();
        return this.auditingStore.getRecords(maxId, sinceId, maxResults, offset, filter, includeSysAdminActions);
    }

    protected long countRecords(@Nullable Long maxId, @Nullable Long sinceId, boolean includeSysAdminActions) {
        return this.auditingStore.countRecords(maxId, sinceId, includeSysAdminActions);
    }

    @Nullable
    protected String getRemoteAddress() {
        return ExecutingHttpRequest.get() != null ? ExecutingHttpRequest.get().getRemoteAddr() : null;
    }

    protected ApplicationUser getLoggedInUser() {
        return this.authenticationContext.getUser();
    }

    protected static I18nHelper getI18n() {
        return ComponentAccessor.getI18nHelperFactory().getInstance(Locale.ENGLISH);
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this.auditingEventListener);
        this.ensureDefaultRetentionPeriodForOnDemand();
    }

    private void ensureDefaultRetentionPeriodForOnDemand() {
        AuditingRetentionPeriod retentionPeriod;
        if (this.featureManager.isOnDemand() && (retentionPeriod = AuditingRetentionPeriod.getByValue(this.applicationProperties.getDefaultBackedString("jira.option.auditing.log.retention.period.in.months"))) != null && retentionPeriod.isUnlimited()) {
            this.applicationProperties.setString("jira.option.auditing.log.retention.period.in.months", AuditingRetentionPeriod.getDefault().getValue());
            this.applicationProperties.setString("jira.option.auditing.log.retention.period.last.change.timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        }
    }
}

