/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImpl;
import com.atlassian.jira.avatar.AvatarStore;
import com.atlassian.jira.avatar.AvatarTagger;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.CacheObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingTaggingAvatarStore
implements AvatarStore {
    private static final Logger log = LoggerFactory.getLogger(CachingTaggingAvatarStore.class);
    public static final String AVATAR_ENTITY = "Avatar";
    public static final String ID = "id";
    public static final String FILE_NAME = "fileName";
    public static final String CONTENT_TYPE = "contentType";
    public static final String AVATAR_TYPE = "avatarType";
    public static final String OWNER = "owner";
    public static final String SYSTEM_AVATAR = "systemAvatar";
    private static final String TAGGED_AVATAR_FILE_SUFFIX = "jrvtg.png";
    private static final int IS_SYSTEM = 1;
    private static final int NOT_SYSTEM = 0;
    private final Cache<Long, CacheObject<Avatar>> avatars;
    private final Cache<Long, CacheObject<Avatar>> taggedAvatars;
    private OfBizDelegator ofBizDelegator;
    private final AvatarTagger avatarTagger;

    public CachingTaggingAvatarStore(OfBizDelegator ofBizDelegator, AvatarTagger avatarTagger, CacheManager cacheManager) {
        String classPrefix = CachingTaggingAvatarStore.class.getName();
        this.taggedAvatars = cacheManager.getCache(classPrefix + ".taggedAvatars", (CacheLoader)new TagAndRetrieve());
        this.avatars = cacheManager.getCache(classPrefix + ".avatars", (CacheLoader)new CheckForTaggedVersionFallbackToDb());
        this.ofBizDelegator = ofBizDelegator;
        this.avatarTagger = avatarTagger;
    }

    @Override
    public Avatar getById(Long avatarId) {
        return (Avatar)((CacheObject)this.avatars.get((Object)avatarId)).getValue();
    }

    @Override
    public Avatar getByIdTagged(Long avatarId) {
        Avatar taggedAvatar = (Avatar)((CacheObject)this.taggedAvatars.get((Object)avatarId)).getValue();
        this.avatars.remove((Object)avatarId);
        return taggedAvatar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(Long avatarId) {
        Assertions.notNull((String)"avatarId", (Object)avatarId);
        try {
            int numRemoved = this.ofBizDelegator.removeByAnd(AVATAR_ENTITY, (Map)FieldMap.build((String)ID, (Object)avatarId));
            boolean bl = numRemoved != 0;
            return bl;
        }
        finally {
            this.taggedAvatars.remove((Object)avatarId);
            this.avatars.remove((Object)avatarId);
        }
    }

    @Override
    public void update(Avatar avatar) {
        Assertions.notNull((String)"avatar", (Object)avatar);
        Long avatarId = (Long)Assertions.notNull((String)"avatar.id", (Object)avatar.getId());
        Assertions.notNull((String)"avatar.fileName", (Object)avatar.getFileName());
        Assertions.notNull((String)"avatar.contentType", (Object)avatar.getContentType());
        Assertions.notNull((String)"avatar.avatarType", (Object)avatar.getAvatarType());
        Assertions.notNull((String)"avatar.owner", (Object)avatar.getOwner());
        GenericValue gv = this.ofBizDelegator.findById(AVATAR_ENTITY, avatarId);
        gv.setNonPKFields(this.getNonPkFields(avatar));
        try {
            gv.store();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        finally {
            this.taggedAvatars.remove((Object)avatarId);
            this.avatars.remove((Object)avatarId);
        }
    }

    @Override
    public Avatar create(Avatar avatar) {
        Assertions.notNull((String)"avatar", (Object)avatar);
        Assertions.stateTrue((String)"avatar.id must be null", (avatar.getId() == null ? 1 : 0) != 0);
        Assertions.notNull((String)"avatar.fileName", (Object)avatar.getFileName());
        Assertions.notNull((String)"avatar.contentType", (Object)avatar.getContentType());
        Assertions.notNull((String)"avatar.avatarType", (Object)avatar.getAvatarType());
        return this.gvToAvatar(this.ofBizDelegator.createValue(AVATAR_ENTITY, this.getNonPkFields(avatar)));
    }

    @Override
    public List<Avatar> getAllSystemAvatars(Avatar.Type type) {
        return this.getAvatars((Map<String, ?>)FieldMap.build((String)SYSTEM_AVATAR, (Object)1, (String)AVATAR_TYPE, (Object)type.getName()));
    }

    @Override
    public List<Avatar> getCustomAvatarsForOwner(Avatar.Type type, String ownerId) {
        Assertions.notNull((String)"type", (Object)type);
        Assertions.notNull((String)"ownerId", (Object)ownerId);
        return this.getAvatars((Map<String, ?>)FieldMap.build((String)SYSTEM_AVATAR, (Object)0, (String)AVATAR_TYPE, (Object)type.getName(), (String)OWNER, (Object)ownerId));
    }

    List<Avatar> getAvatars(Map<String, ?> constraint) {
        List genericValues = this.ofBizDelegator.findByAnd(AVATAR_ENTITY, constraint);
        ArrayList<Avatar> systemAvatars = new ArrayList<Avatar>(genericValues.size());
        for (GenericValue gv : genericValues) {
            systemAvatars.add(this.gvToAvatar(gv));
        }
        return systemAvatars;
    }

    private Map<String, Object> getNonPkFields(Avatar avatar) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put(FILE_NAME, avatar.getFileName());
        fields.put(CONTENT_TYPE, avatar.getContentType());
        fields.put(AVATAR_TYPE, avatar.getAvatarType().getName());
        fields.put(OWNER, avatar.getOwner());
        fields.put(SYSTEM_AVATAR, avatar.isSystemAvatar() ? 1 : 0);
        return fields;
    }

    Avatar gvToAvatar(GenericValue gv) {
        return new AvatarImpl(gv.getLong(ID), gv.getString(FILE_NAME), gv.getString(CONTENT_TYPE), Avatar.Type.getByName((String)gv.getString(AVATAR_TYPE)), gv.getString(OWNER), gv.getInteger(SYSTEM_AVATAR) != 0);
    }

    void tagLegacyAvatar(GenericValue gv) {
        String fileName = gv.getString(FILE_NAME);
        Long id = gv.getLong(ID);
        Integer isSystem = gv.getInteger(SYSTEM_AVATAR);
        String avatarType = gv.getString(AVATAR_TYPE);
        if (isSystem.equals(1) || !avatarType.equals(Avatar.Type.USER.getName()) || fileName.endsWith(TAGGED_AVATAR_FILE_SUFFIX)) {
            return;
        }
        try {
            String newFileName = this.avatarTagger.tagAvatar(id, fileName);
            gv.setString(FILE_NAME, newFileName);
            gv.setString(CONTENT_TYPE, "image/png");
        }
        catch (IOException | RuntimeException e) {
            log.warn("Could not convert avatar {} to new format with metadata.\nThis avatar may be deleted during an upgrade to the next major version of JIRA.\nAlso, if this avatar is embedded in reply emails picked up by the JIRA email handler, the handler may attach the avatar file to the associated issue", (Object)fileName);
            return;
        }
        try {
            gv.store();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private class TagAndRetrieve
    implements CacheLoader<Long, CacheObject<Avatar>> {
        private TagAndRetrieve() {
        }

        public CacheObject<Avatar> load(@Nullable Long id) {
            GenericValue gv = CachingTaggingAvatarStore.this.ofBizDelegator.findById(CachingTaggingAvatarStore.AVATAR_ENTITY, id);
            if (gv == null) {
                return new CacheObject<Object>(null);
            }
            CachingTaggingAvatarStore.this.tagLegacyAvatar(gv);
            return new CacheObject<Avatar>(CachingTaggingAvatarStore.this.gvToAvatar(gv));
        }
    }

    private class CheckForTaggedVersionFallbackToDb
    implements CacheLoader<Long, CacheObject<Avatar>> {
        private CheckForTaggedVersionFallbackToDb() {
        }

        @ClusterSafe(value="This use of Cache.getKeys() here is just a sort of optimisation and is safe.")
        public CacheObject<Avatar> load(@Nullable Long id) {
            if (CachingTaggingAvatarStore.this.taggedAvatars.getKeys().contains(id)) {
                return (CacheObject)CachingTaggingAvatarStore.this.taggedAvatars.get((Object)id);
            }
            GenericValue gv = CachingTaggingAvatarStore.this.ofBizDelegator.findById(CachingTaggingAvatarStore.AVATAR_ENTITY, id);
            if (gv == null) {
                return new CacheObject<Object>(null);
            }
            return new CacheObject<Avatar>(CachingTaggingAvatarStore.this.gvToAvatar(gv));
        }
    }
}

