/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.portal;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.favourites.FavouritesManager;
import com.atlassian.jira.issue.comparator.PortalPageNameComparator;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortalPageManager;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.ShareTypeValidatorUtils;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.sharing.search.SharedEntitySearchResult;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.util.sharing.SharedEntitySearchAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;

public class DefaultPortalPageService
implements PortalPageService {
    private final PortalPageManager portalPageManager;
    private final ShareTypeValidatorUtils shareTypeValidatorUtils;
    private final FavouritesManager<PortalPage> favouritesManager;
    private final PermissionManager permissionManager;
    private final UserUtil userUtil;

    public DefaultPortalPageService(PortalPageManager portalPageManager, ShareTypeValidatorUtils shareTypeValidatorUtils, FavouritesManager<PortalPage> favouritesManager, PermissionManager permissionManager, UserUtil userUtil) {
        Assertions.notNull((String)"portalPageManager", (Object)portalPageManager);
        Assertions.notNull((String)"shareTypeValidatorUtils", (Object)shareTypeValidatorUtils);
        Assertions.notNull((String)"favouritesManager", favouritesManager);
        Assertions.notNull((String)"permissionManager", (Object)permissionManager);
        Assertions.notNull((String)"userUtil", (Object)userUtil);
        this.userUtil = userUtil;
        this.portalPageManager = portalPageManager;
        this.shareTypeValidatorUtils = shareTypeValidatorUtils;
        this.favouritesManager = favouritesManager;
        this.permissionManager = permissionManager;
    }

    public Collection<PortalPage> getFavouritePortalPages(ApplicationUser user) {
        Collection<Long> ids = this.getFavouriteIds(user);
        ArrayList<PortalPage> results = new ArrayList<PortalPage>(ids.size());
        for (Long id : ids) {
            PortalPage portalPage = this.portalPageManager.getPortalPage(user, id);
            if (portalPage == null) continue;
            results.add(portalPage);
        }
        return results;
    }

    public boolean isFavourite(ApplicationUser user, PortalPage portalPage) {
        Assertions.notNull((String)"portalPage", (Object)portalPage);
        if (user == null) {
            return false;
        }
        try {
            return this.favouritesManager.isFavourite(user, (SharedEntity)portalPage);
        }
        catch (PermissionException e) {
            return false;
        }
    }

    public Collection<PortalPage> getOwnedPortalPages(ApplicationUser user) {
        if (user == null) {
            return Collections.emptyList();
        }
        Collection allOwnedPortalPages = this.portalPageManager.getAllOwnedPortalPages(user);
        return DefaultPortalPageService.sortByName(allOwnedPortalPages);
    }

    public Collection<PortalPage> getNonPrivatePortalPages(ApplicationUser user) {
        Collection<PortalPage> portalPages = this.getOwnedPortalPages(user);
        CollectionUtils.filter(portalPages, (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                PortalPage portalPage = (PortalPage)o;
                return !portalPage.getPermissions().isPrivate();
            }
        });
        return portalPages;
    }

    public Collection<PortalPage> getPortalPagesFavouritedByOthers(ApplicationUser user) {
        Collection<PortalPage> nonPrivatePortalPages = this.getNonPrivatePortalPages(user);
        if (!nonPrivatePortalPages.isEmpty()) {
            final Collection favouriteIds = this.favouritesManager.getFavouriteIds(user, PortalPage.ENTITY_TYPE);
            CollectionUtils.filter(nonPrivatePortalPages, (Predicate)new Predicate(){

                public boolean evaluate(Object o) {
                    PortalPage portalPage = (PortalPage)o;
                    return favouriteIds.contains(portalPage.getId()) ? portalPage.getFavouriteCount() > 1L : portalPage.getFavouriteCount() > 0L;
                }
            });
        }
        return nonPrivatePortalPages;
    }

    public PortalPage getPortalPage(JiraServiceContext context, Long portalPageId) {
        Assertions.notNull((String)"context", (Object)context);
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        PortalPage portalPage = this.portalPageManager.getPortalPage(context.getLoggedInApplicationUser(), portalPageId);
        if (portalPage == null) {
            context.getErrorCollection().addErrorMessage(context.getI18nBean().getText("admin.errors.portalpages.no.access"));
        }
        return portalPage;
    }

    public boolean validateForGetPortalPage(JiraServiceContext context, Long portalPageId) {
        Assertions.notNull((String)"context", (Object)context);
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        PortalPage portalPage = this.portalPageManager.getPortalPage(context.getLoggedInApplicationUser(), portalPageId);
        if (portalPage == null) {
            context.getErrorCollection().addErrorMessage(context.getI18nBean().getText("admin.errors.portalpages.no.access"));
            return false;
        }
        return true;
    }

    public PortalPage getSystemDefaultPortalPage() {
        return this.portalPageManager.getSystemDefaultPortalPage();
    }

    public boolean validateForCreate(JiraServiceContext serviceCtx, PortalPage portalPage) {
        PortalPage byName;
        Assertions.notNull((String)"serviceCtx", (Object)serviceCtx);
        Assertions.notNull((String)"portalPage", (Object)portalPage);
        this.checkPermissionsForCreate(serviceCtx, portalPage);
        if (StringUtils.isBlank((String)portalPage.getName())) {
            serviceCtx.getErrorCollection().addError("portalPageName", serviceCtx.getI18nBean().getText("admin.errors.portalpages.must.specify.name"));
        } else if (serviceCtx.getLoggedInApplicationUser() != null && (byName = this.portalPageManager.getPortalPageByName(serviceCtx.getLoggedInApplicationUser(), portalPage.getName())) != null) {
            serviceCtx.getErrorCollection().addError("portalPageName", serviceCtx.getI18nBean().getText("admin.errors.portalpages.same.name"));
        }
        if (StringUtils.isNotBlank((String)portalPage.getDescription()) && portalPage.getDescription().length() > 255) {
            serviceCtx.getErrorCollection().addError("portalPageDescription", serviceCtx.getI18nBean().getText("admin.errors.portalpages.description.too.long"));
        }
        return !serviceCtx.getErrorCollection().hasAnyErrors();
    }

    public PortalPage createPortalPage(JiraServiceContext serviceCtx, PortalPage portalPage) {
        Assertions.notNull((String)"serviceCtx", (Object)serviceCtx);
        Assertions.notNull((String)"portalPage", (Object)portalPage);
        return this.createPortalPage(serviceCtx, portalPage, false);
    }

    public PortalPage createPortalPage(JiraServiceContext serviceCtx, PortalPage portalPage, boolean isFavourite) {
        Assertions.notNull((String)"serviceCtx", (Object)serviceCtx);
        Assertions.notNull((String)"portalPage", (Object)portalPage);
        PortalPage newPortalPage = null;
        if (this.checkPermissionsForCreate(serviceCtx, portalPage)) {
            newPortalPage = this.portalPageManager.create(portalPage);
        }
        if (newPortalPage != null && isFavourite) {
            try {
                this.favouritesManager.addFavourite(serviceCtx.getLoggedInApplicationUser(), (SharedEntity)newPortalPage);
            }
            catch (PermissionException e) {
                serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("common.favourites.not.added"));
            }
        }
        return newPortalPage;
    }

    public boolean validateForCreatePortalPageByClone(JiraServiceContext serviceCtx, PortalPage portalPage, Long clonePortalPageId) {
        this.checkForClone(serviceCtx, portalPage, clonePortalPageId);
        return !serviceCtx.getErrorCollection().hasAnyErrors();
    }

    private PortalPage checkForClone(JiraServiceContext serviceCtx, PortalPage portalPage, Long clonePortalPageId) {
        boolean ok = this.validateForCreate(serviceCtx, portalPage);
        PortalPage clonePortalPage = null;
        if (ok && serviceCtx.getLoggedInApplicationUser() != null) {
            PortalPage tempClonePortalPage = this.portalPageManager.getPortalPage(serviceCtx.getLoggedInApplicationUser(), clonePortalPageId);
            if (tempClonePortalPage == null) {
                serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.portalpages.clone.does.not.exist"));
            } else {
                clonePortalPage = tempClonePortalPage;
            }
        }
        return clonePortalPage;
    }

    public PortalPage createPortalPageByClone(JiraServiceContext serviceCtx, PortalPage portalPage, Long clonePortalPageId, boolean isFavourite) {
        Assertions.notNull((String)"serviceCtx", (Object)serviceCtx);
        Assertions.notNull((String)"portalPage", (Object)portalPage);
        Assertions.notNull((String)"clonePortalPageId", (Object)clonePortalPageId);
        PortalPage clonePortalPage = this.checkForClone(serviceCtx, portalPage, clonePortalPageId);
        if (clonePortalPage == null) {
            return null;
        }
        PortalPage newPortalPage = this.portalPageManager.createBasedOnClone(serviceCtx.getLoggedInApplicationUser(), portalPage, clonePortalPage);
        if (newPortalPage != null && isFavourite) {
            try {
                this.favouritesManager.addFavourite(serviceCtx.getLoggedInApplicationUser(), (SharedEntity)newPortalPage);
            }
            catch (PermissionException e) {
                serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("common.favourites.not.added"));
            }
        }
        return newPortalPage;
    }

    public boolean validateForDelete(JiraServiceContext serviceCtx, Long portalPageId) {
        Assertions.notNull((String)"serviceCtx", (Object)serviceCtx);
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        ApplicationUser user = serviceCtx.getLoggedInApplicationUser();
        ErrorCollection errorCollection = serviceCtx.getErrorCollection();
        if (user == null) {
            errorCollection.addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.portalpages.owned.anonymous.user"));
        } else {
            PortalPage page = this.portalPageManager.getPortalPageById(portalPageId);
            if (page == null) {
                errorCollection.addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.portalpages.nonexistent"));
            } else if (page.isSystemDefaultPortalPage()) {
                errorCollection.addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.portalpages.not.delete.system.default"));
            } else if (!user.equals((Object)page.getOwner())) {
                errorCollection.addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.portalpages.must.be.owner"));
            }
        }
        return !errorCollection.hasAnyErrors();
    }

    public void deleteAllPortalPagesForUser(ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        Collection ownedPortalPages = this.portalPageManager.getAllOwnedPortalPages(user);
        for (PortalPage portalPage : ownedPortalPages) {
            this.deletePortalPageImpl(portalPage);
        }
        this.favouritesManager.removeFavouritesForUser(user, PortalPage.ENTITY_TYPE);
    }

    public void deletePortalPage(JiraServiceContext serviceCtx, Long portalPageId) {
        Assertions.notNull((String)"serviceCtx", (Object)serviceCtx);
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        ApplicationUser user = serviceCtx.getLoggedInApplicationUser();
        this.validateForDelete(serviceCtx, portalPageId);
        if (!serviceCtx.getErrorCollection().hasAnyErrors()) {
            PortalPage portalPage = this.portalPageManager.getPortalPage(user, portalPageId);
            if (portalPage != null) {
                this.deletePortalPageImpl(portalPage);
            } else {
                serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.portalpages.nonexistent"));
            }
        }
    }

    public boolean validateForUpdate(JiraServiceContext serviceCtx, PortalPage portalPage) {
        Assertions.notNull((String)"serviceCtx", (Object)serviceCtx);
        Assertions.notNull((String)"portalPage", (Object)portalPage);
        if (StringUtils.isBlank((String)portalPage.getName())) {
            serviceCtx.getErrorCollection().addError("portalPageName", serviceCtx.getI18nBean().getText("admin.errors.portalpages.must.specify.name"));
        } else if (portalPage.isSystemDefaultPortalPage()) {
            this.checkSystemDefaultPageForUpdate(serviceCtx, portalPage);
        } else {
            PortalPage portalPageByName;
            boolean ok = this.checkOwnerShipAndExistenceAndSharePermissions(serviceCtx, portalPage);
            if (ok && serviceCtx.getLoggedInApplicationUser() != null && (portalPageByName = this.portalPageManager.getPortalPageByName(serviceCtx.getLoggedInApplicationUser(), portalPage.getName())) != null && !portalPage.getId().equals(portalPageByName.getId())) {
                serviceCtx.getErrorCollection().addError("portalPageName", serviceCtx.getI18nBean().getText("admin.errors.portalpages.same.name"));
            }
        }
        if (StringUtils.isNotBlank((String)portalPage.getDescription()) && portalPage.getDescription().length() > 255) {
            serviceCtx.getErrorCollection().addError("portalPageDescription", serviceCtx.getI18nBean().getText("admin.errors.portalpages.description.too.long"));
        }
        return !serviceCtx.getErrorCollection().hasAnyErrors();
    }

    public PortalPage updatePortalPage(JiraServiceContext serviceCtx, PortalPage portalPage, boolean isFavourite) {
        Assertions.notNull((String)"serviceCtx", (Object)serviceCtx);
        Assertions.notNull((String)"portalPage", (Object)portalPage);
        if (this.validateForUpdate(serviceCtx, portalPage)) {
            PortalPage updatedPortalPage = this.portalPageManager.update(portalPage);
            if (isFavourite) {
                try {
                    this.favouritesManager.addFavourite(serviceCtx.getLoggedInApplicationUser(), (SharedEntity)updatedPortalPage);
                }
                catch (PermissionException e) {
                    serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("common.favourites.not.added"));
                }
            } else {
                this.favouritesManager.removeFavourite(serviceCtx.getLoggedInApplicationUser(), (SharedEntity)updatedPortalPage);
            }
            return updatedPortalPage;
        }
        return null;
    }

    public void validateForChangeOwner(JiraServiceContext serviceCtx, PortalPage page) {
        Assertions.notNull((String)"serviceCtx", (Object)serviceCtx);
        Assertions.notNull((String)"page", (Object)page);
        if (serviceCtx.getLoggedInApplicationUser() != null) {
            PortalPage portalPageByName = this.portalPageManager.getPortalPageByName(serviceCtx.getLoggedInApplicationUser(), page.getName());
            if (portalPageByName != null && !page.getId().equals(portalPageByName.getId())) {
                serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.portalpages.already.owns.same.name", serviceCtx.getLoggedInApplicationUser().getDisplayName()));
            }
            if (page.getPermissions().isPrivate()) {
                serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.portalpages.private"));
            }
        }
    }

    public PortalPage updatePortalPageUnconditionally(JiraServiceContext serviceCtx, ApplicationUser user, PortalPage portalPage) {
        Assertions.notNull((String)"serviceCtx", (Object)serviceCtx);
        Assertions.notNull((String)"portalPage", (Object)portalPage);
        Assertions.notNull((String)"user", (Object)user);
        if (this.permissionManager.hasPermission(0, user)) {
            return this.portalPageManager.update(portalPage);
        }
        return null;
    }

    public boolean validateForChangePortalPageSequence(JiraServiceContext serviceCtx, Long portalPageId) {
        Assertions.notNull((String)"serviceCtx", (Object)serviceCtx);
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        this.checkPermissionsForMove(serviceCtx, portalPageId);
        return !serviceCtx.getErrorCollection().hasAnyErrors();
    }

    public void increasePortalPageSequence(JiraServiceContext serviceCtx, Long portalPageId) {
        Assertions.notNull((String)"serviceCtx", (Object)serviceCtx);
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        PortalPage portalPage = this.checkPermissionsForMove(serviceCtx, portalPageId);
        if (portalPage != null && !serviceCtx.getErrorCollection().hasAnyErrors()) {
            try {
                this.favouritesManager.increaseFavouriteSequence(serviceCtx.getLoggedInApplicationUser(), (SharedEntity)portalPage);
            }
            catch (PermissionException e) {
                serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("common.favourites.not.changed"));
            }
        }
    }

    public void decreasePortalPageSequence(JiraServiceContext serviceCtx, Long portalPageId) {
        Assertions.notNull((String)"serviceCtx", (Object)serviceCtx);
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        PortalPage portalPage = this.checkPermissionsForMove(serviceCtx, portalPageId);
        if (portalPage != null && !serviceCtx.getErrorCollection().hasAnyErrors()) {
            try {
                this.favouritesManager.decreaseFavouriteSequence(serviceCtx.getLoggedInApplicationUser(), (SharedEntity)portalPage);
            }
            catch (PermissionException e) {
                serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("common.favourites.not.changed"));
            }
        }
    }

    public void moveToStartPortalPageSequence(JiraServiceContext serviceCtx, Long portalPageId) {
        Assertions.notNull((String)"serviceCtx", (Object)serviceCtx);
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        PortalPage portalPage = this.checkPermissionsForMove(serviceCtx, portalPageId);
        if (portalPage != null && !serviceCtx.getErrorCollection().hasAnyErrors()) {
            try {
                this.favouritesManager.moveToStartFavouriteSequence(serviceCtx.getLoggedInApplicationUser(), (SharedEntity)portalPage);
            }
            catch (PermissionException e) {
                serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("common.favourites.not.changed"));
            }
        }
    }

    public void moveToEndPortalPageSequence(JiraServiceContext serviceCtx, Long portalPageId) {
        Assertions.notNull((String)"serviceCtx", (Object)serviceCtx);
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        PortalPage portalPage = this.checkPermissionsForMove(serviceCtx, portalPageId);
        if (portalPage != null && !serviceCtx.getErrorCollection().hasAnyErrors()) {
            try {
                this.favouritesManager.moveToEndFavouriteSequence(serviceCtx.getLoggedInApplicationUser(), (SharedEntity)portalPage);
            }
            catch (PermissionException e) {
                serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("common.favourites.not.changed"));
            }
        }
    }

    public void saveLegacyPortletConfiguration(JiraServiceContext serviceCtx, PortletConfiguration portletConfiguration) {
        Assertions.notNull((String)"serviceCtx", (Object)serviceCtx);
        Assertions.notNull((String)"portletConfiguration", (Object)portletConfiguration);
        this.portalPageManager.saveLegacyPortletConfiguration(portletConfiguration);
    }

    public void validateForSearch(JiraServiceContext serviceCtx, SharedEntitySearchParameters searchParameters) {
        ShareTypeSearchParameter shareTypeSearchParameter;
        Assertions.notNull((String)"serviceCtx", (Object)serviceCtx);
        Assertions.notNull((String)"searchParameters", (Object)searchParameters);
        ErrorCollection errorCollection = serviceCtx.getErrorCollection();
        I18nHelper i18nHelper = serviceCtx.getI18nBean();
        String searchOwnerUserName = searchParameters.getUserName();
        if (!StringUtils.isBlank((String)searchOwnerUserName) && !this.userUtil.userExists(searchOwnerUserName)) {
            errorCollection.addError("searchOwnerUserName", i18nHelper.getText("admin.errors.portalpages.userdoesnotexist", searchOwnerUserName));
        }
        if ((shareTypeSearchParameter = searchParameters.getShareTypeParameter()) != null) {
            this.shareTypeValidatorUtils.isValidSearchParameter(serviceCtx, shareTypeSearchParameter);
        }
        SharedEntitySearchAction.QueryValidator.validate(searchParameters, errorCollection, serviceCtx.getI18nBean());
    }

    public SharedEntitySearchResult<PortalPage> search(JiraServiceContext serviceCtx, SharedEntitySearchParameters searchParameters, int pagePosition, int pageWidth) {
        Assertions.notNull((String)"serviceCtx", (Object)serviceCtx);
        Assertions.notNull((String)"searchParameters", (Object)searchParameters);
        if (pagePosition < 0) {
            throw new IllegalArgumentException("pagePosition < 0");
        }
        if (pageWidth <= 0) {
            throw new IllegalArgumentException("pageWidth <= 0");
        }
        return this.portalPageManager.search(searchParameters, serviceCtx.getLoggedInApplicationUser(), pagePosition, pageWidth);
    }

    public List<List<PortletConfiguration>> getPortletConfigurations(JiraServiceContext serviceCtx, Long portalPageId) {
        Assertions.notNull((String)"serviceCtx", (Object)serviceCtx);
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        if (this.validateForGetPortalPage(serviceCtx, portalPageId)) {
            return this.portalPageManager.getPortletConfigurations(portalPageId);
        }
        return Collections.emptyList();
    }

    protected boolean checkSystemDefaultSharePermissions(JiraServiceContext serviceCtx, SharedEntity.SharePermissions sharePermissions) {
        if (!sharePermissions.isGlobal()) {
            serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.portalpages.sysdefault.must.be.public"));
            return false;
        }
        return true;
    }

    boolean checkSystemDefaultPageForUpdate(JiraServiceContext serviceCtx, PortalPage portalPage) {
        if (portalPage.isSystemDefaultPortalPage()) {
            if (!this.permissionManager.hasPermission(0, serviceCtx.getLoggedInApplicationUser())) {
                serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.portalpages.must.be.admin.change.sysdefault"));
                return false;
            }
            return this.checkSystemDefaultSharePermissions(serviceCtx, portalPage.getPermissions());
        }
        return !serviceCtx.getErrorCollection().hasAnyErrors();
    }

    boolean checkOwnerShipAndExistenceAndSharePermissions(JiraServiceContext serviceCtx, PortalPage portalPage) {
        this.checkOwnerShipAndExistence(serviceCtx, portalPage);
        this.shareTypeValidatorUtils.isValidSharePermission(serviceCtx, (SharedEntity)portalPage);
        return !serviceCtx.getErrorCollection().hasAnyErrors();
    }

    boolean checkOwnerShipAndExistence(JiraServiceContext serviceCtx, PortalPage portalPage) {
        if (serviceCtx.getLoggedInApplicationUser() == null) {
            serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.portalpages.owned.anonymous.user"));
        } else if (portalPage.getOwner() == null || !serviceCtx.getLoggedInApplicationUser().equals((Object)portalPage.getOwner())) {
            serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.portalpages.must.be.owner"));
        } else {
            PortalPage readPage = this.portalPageManager.getPortalPageById(portalPage.getId());
            if (readPage == null) {
                serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.portalpages.not.saved"));
            } else if (!serviceCtx.getLoggedInApplicationUser().equals((Object)readPage.getOwner())) {
                serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.portalpages.must.be.owner"));
            }
        }
        return !serviceCtx.getErrorCollection().hasAnyErrors();
    }

    private PortalPage checkPermissionsForMove(JiraServiceContext serviceCtx, Long portalPageId) {
        PortalPage portalPage = null;
        if (serviceCtx.getLoggedInApplicationUser() == null) {
            serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.portalpages.owned.anonymous.user"));
        } else {
            portalPage = this.getPortalPage(serviceCtx, portalPageId);
            if (portalPage != null && !this.isFavourite(serviceCtx.getLoggedInApplicationUser(), portalPage)) {
                serviceCtx.getErrorCollection().addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.portalpages.not.favourite"));
                portalPage = null;
            }
        }
        return portalPage;
    }

    private boolean checkPermissionsForCreate(JiraServiceContext serviceCtx, PortalPage portalPage) {
        this.checkOwnership(serviceCtx, portalPage);
        this.shareTypeValidatorUtils.isValidSharePermission(serviceCtx, (SharedEntity)portalPage);
        return !serviceCtx.getErrorCollection().hasAnyErrors();
    }

    private boolean checkOwnership(JiraServiceContext serviceCtx, PortalPage portalPage) {
        ApplicationUser user = serviceCtx.getLoggedInApplicationUser();
        ErrorCollection errorCollection = serviceCtx.getErrorCollection();
        if (user == null) {
            errorCollection.addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.portalpages.owned.anonymous.user"));
        } else if (portalPage.getOwner() == null || !portalPage.getOwner().equals((Object)user)) {
            errorCollection.addErrorMessage(serviceCtx.getI18nBean().getText("admin.errors.portalpages.must.be.owner"));
        }
        return !errorCollection.hasAnyErrors();
    }

    private static Collection<PortalPage> sortByName(Collection<PortalPage> portalPages) {
        if (portalPages.isEmpty()) {
            return portalPages;
        }
        ArrayList<PortalPage> portalPagesList = new ArrayList<PortalPage>(portalPages);
        Collections.sort(portalPagesList, PortalPageNameComparator.COMPARATOR);
        return portalPagesList;
    }

    private Collection<Long> getFavouriteIds(ApplicationUser user) {
        return user == null ? Collections.emptyList() : this.favouritesManager.getFavouriteIds(user, PortalPage.ENTITY_TYPE);
    }

    private void deletePortalPageImpl(PortalPage portalPage) {
        Assertions.notNull((String)"portalPage", (Object)portalPage);
        this.favouritesManager.removeFavouritesForEntityDelete((SharedEntity)portalPage);
        this.portalPageManager.delete(portalPage.getId());
    }
}

