/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.opensymphony.util.TextUtils;

class ProjectNameValidator {
    private final ProjectService projectService;
    private final ProjectManager projectManager;

    public ProjectNameValidator(ProjectService projectService, ProjectManager projectManager) {
        this.projectService = projectService;
        this.projectManager = projectManager;
    }

    public void validateForUpdate(String name, String key, ErrorCollection errorCollection, I18nHelper i18nBean) {
        this.validate(name, key, errorCollection, i18nBean, true);
    }

    public void validateForCreate(String name, ErrorCollection errorCollection, I18nHelper i18nBean) {
        this.validate(name, null, errorCollection, i18nBean, false);
    }

    private void validate(String name, String key, ErrorCollection errors, I18nHelper i18nBean, boolean forupdate) {
        if (!TextUtils.stringSet((String)name)) {
            errors.addError("projectName", i18nBean.getText("admin.errors.must.specify.a.valid.project.name"));
        } else if (name.length() > this.projectService.getMaximumNameLength()) {
            errors.addError("projectName", i18nBean.getText("admin.errors.project.name.too.long", (Object)this.projectService.getMaximumNameLength()));
        } else if (name.length() < 2) {
            errors.addError("projectName", i18nBean.getText("admin.errors.project.name.too.short", (Object)2));
        } else {
            Project project = this.projectManager.getProjectObjByName(name);
            if (!(project == null || forupdate && this.isTheSameProject(key, project))) {
                errors.addError("projectName", i18nBean.getText("admin.errors.project.with.that.name.already.exists"));
            }
        }
    }

    private boolean isTheSameProject(String key, Project project) {
        return key.equals(project.getKey());
    }
}

